/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.quarkus.gizmo2.Assignable;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.ParamVar;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ClassCreator;
import io.quarkus.gizmo2.creator.ops.StringBuilderOps;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import io.smallrye.common.constraint.Assert;
import java.lang.constant.ClassDesc;
import java.util.List;

public class EqualsHashCodeToStringGenerator {
    private final ClassCreator cc;
    private final List<FieldDesc> fields;

    public EqualsHashCodeToStringGenerator(ClassCreator cc, List<FieldDesc> fields) {
        this.cc = cc;
        this.fields = fields;
    }

    public void generateEquals() {
        MethodDesc floatToIntBits = MethodDesc.of(Float.class, "floatToIntBits", Integer.TYPE, Float.TYPE);
        MethodDesc doubleToLongBits = MethodDesc.of(Double.class, "doubleToLongBits", Long.TYPE, Double.TYPE);
        ClassDesc thisClass = this.cc.type();
        this.cc.method("equals", mc -> {
            mc.public_();
            mc.returning(Boolean.TYPE);
            ParamVar other = mc.parameter("other", Object.class);
            mc.body(b0 -> {
                b0.if_(b0.eq((Expr)this.cc.this_(), other), BlockCreator::returnTrue);
                b0.ifNotInstanceOf((Expr)other, thisClass, BlockCreator::returnFalse);
                LocalVar otherCast = b0.localVar("other", b0.cast((Expr)other, thisClass));
                block7: for (FieldDesc field : this.fields) {
                    if (!field.owner().equals(thisClass)) {
                        throw new IllegalArgumentException("Field does not belong to " + thisClass.displayName() + ": " + String.valueOf(field));
                    }
                    LocalVar thisValue = b0.localVar("thisValue", b0.get(this.cc.this_().field(field)));
                    LocalVar thatValue = b0.localVar("thatValue", b0.get(otherCast.field(field)));
                    String fieldDesc = field.type().descriptorString();
                    switch (fieldDesc.charAt(0)) {
                        case 'B': 
                        case 'C': 
                        case 'I': 
                        case 'J': 
                        case 'S': 
                        case 'Z': {
                            b0.if_(b0.ne((Expr)thisValue, thatValue), BlockCreator::returnFalse);
                            continue block7;
                        }
                        case 'F': {
                            Expr thisBits = b0.invokeStatic(floatToIntBits, thisValue);
                            Expr thatBits = b0.invokeStatic(floatToIntBits, thatValue);
                            b0.if_(b0.ne(thisBits, thatBits), BlockCreator::returnFalse);
                            continue block7;
                        }
                        case 'D': {
                            Expr thisBits = b0.invokeStatic(doubleToLongBits, thisValue);
                            Expr thatBits = b0.invokeStatic(doubleToLongBits, thatValue);
                            b0.if_(b0.ne(thisBits, thatBits), BlockCreator::returnFalse);
                            continue block7;
                        }
                        case 'L': {
                            b0.ifNot(b0.objEquals(thisValue, thatValue), BlockCreator::returnFalse);
                            continue block7;
                        }
                        case '[': {
                            b0.ifNot(b0.arrayEquals(thisValue, thatValue), BlockCreator::returnFalse);
                            continue block7;
                        }
                    }
                    throw Assert.impossibleSwitchCase((Object)field);
                }
                b0.return_(true);
            });
        });
    }

    public void generateHashCode() {
        ClassDesc thisClass = this.cc.type();
        this.cc.method("hashCode", mc -> {
            mc.public_();
            mc.returning(Integer.TYPE);
            mc.body(b0 -> {
                if (this.fields.isEmpty()) {
                    b0.return_(0);
                    return;
                }
                LocalVar result = b0.localVar("result", Const.of(1));
                for (FieldDesc field : this.fields) {
                    if (!field.owner().equals(thisClass)) {
                        throw new IllegalArgumentException("Field does not belong to " + thisClass.displayName() + ": " + String.valueOf(field));
                    }
                    LocalVar value = b0.localVar("value", b0.get(this.cc.this_().field(field)));
                    LocalVar hash = b0.localVar("hash", field.type().isArray() ? b0.arrayHashCode(value) : b0.objHashCode(value));
                    b0.set((Assignable)result, b0.add(b0.mul((Expr)Const.of(31), result), hash));
                }
                b0.return_(result);
            });
        });
    }

    public void generateToString() {
        ClassDesc thisClass = this.cc.type();
        this.cc.method("toString", mc -> {
            mc.public_();
            mc.returning(String.class);
            mc.body(b0 -> {
                StringBuilderOps result = b0.withNewStringBuilder();
                result.append(thisClass.displayName() + "(");
                boolean first = true;
                for (FieldDesc field : this.fields) {
                    if (!field.owner().equals(thisClass)) {
                        throw new IllegalArgumentException("Field does not belong to " + thisClass.displayName() + ": " + String.valueOf(field));
                    }
                    if (first) {
                        result.append(field.name() + "=");
                    } else {
                        result.append(", " + field.name() + "=");
                    }
                    Expr value = b0.get(this.cc.this_().field(field));
                    result.append(field.type().isArray() ? b0.arrayToString(value) : value);
                    first = false;
                }
                result.append(')');
                b0.return_(result.toString_());
            });
        });
    }
}

