/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo;

import io.quarkus.gizmo.AbstractSwitch;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.BytecodeCreatorImpl;
import io.quarkus.gizmo.Gizmo;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.Switch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

class StringSwitchImpl
extends AbstractSwitch<String>
implements Switch.StringSwitch {
    private final Map<String, BytecodeCreatorImpl> caseBlocks = new LinkedHashMap<String, BytecodeCreatorImpl>();

    public StringSwitchImpl(final ResultHandle value, BytecodeCreatorImpl enclosing) {
        super(enclosing);
        final ResultHandle strHash = this.invokeVirtualMethod(MethodDescriptor.ofMethod(Object.class, "hashCode", Integer.TYPE, new Class[0]), value, new ResultHandle[0]);
        final HashSet<ResultHandle> inputHandles = new HashSet<ResultHandle>();
        inputHandles.add(value);
        inputHandles.add(strHash);
        this.operations.add(new BytecodeCreatorImpl.Operation(){

            @Override
            void writeBytecode(MethodVisitor methodVisitor) {
                HashMap<Integer, Label> hashToLabel = new HashMap<Integer, Label>();
                ArrayList<BytecodeCreatorImpl> lookupBlocks = new ArrayList<BytecodeCreatorImpl>();
                LinkedHashMap<Integer, ArrayList<Map.Entry<String, BytecodeCreatorImpl>>> hashToCaseBlocks = new LinkedHashMap<Integer, ArrayList<Map.Entry<String, BytecodeCreatorImpl>>>();
                for (Map.Entry<String, BytecodeCreatorImpl> entry : StringSwitchImpl.this.caseBlocks.entrySet()) {
                    int hashCode = entry.getKey().hashCode();
                    ArrayList<Map.Entry<String, BytecodeCreatorImpl>> list = (ArrayList<Map.Entry<String, BytecodeCreatorImpl>>)hashToCaseBlocks.get(hashCode);
                    if (list == null) {
                        list = new ArrayList<Map.Entry<String, BytecodeCreatorImpl>>();
                        hashToCaseBlocks.put(hashCode, list);
                    }
                    list.add(entry);
                }
                for (Map.Entry<String, BytecodeCreatorImpl> entry : hashToCaseBlocks.entrySet()) {
                    BytecodeCreatorImpl lookupBlock = new BytecodeCreatorImpl(StringSwitchImpl.this);
                    Iterator it = ((List)((Object)entry.getValue())).iterator();
                    while (it.hasNext()) {
                        Map.Entry caseEntry = (Map.Entry)it.next();
                        BytecodeCreatorImpl caseBlock = (BytecodeCreatorImpl)caseEntry.getValue();
                        if (caseBlock != null && !StringSwitchImpl.this.fallThrough) {
                            caseBlock.breakScope(StringSwitchImpl.this);
                        } else if (caseBlock == null) {
                            caseBlock = new BytecodeCreatorImpl(StringSwitchImpl.this);
                            caseEntry.setValue(caseBlock);
                        }
                        BytecodeCreatorImpl isEqual = (BytecodeCreatorImpl)lookupBlock.ifTrue(Gizmo.equals(lookupBlock, lookupBlock.load((String)caseEntry.getKey()), value)).trueBranch();
                        isEqual.jumpTo(caseBlock);
                        if (it.hasNext()) continue;
                        lookupBlock.jumpTo(StringSwitchImpl.this.defaultBlock);
                    }
                    hashToLabel.put((Integer)((Object)entry.getKey()), lookupBlock.getTop());
                    lookupBlock.findActiveResultHandles(inputHandles);
                    lookupBlocks.add(lookupBlock);
                }
                StringSwitchImpl.this.loadResultHandle(methodVisitor, strHash, StringSwitchImpl.this, "I");
                int[] keys = hashToCaseBlocks.keySet().stream().mapToInt(e -> e).sorted().toArray();
                Label[] labelArray = new Label[keys.length];
                for (int i = 0; i < keys.length; ++i) {
                    labelArray[i] = (Label)hashToLabel.get(keys[i]);
                }
                methodVisitor.visitLookupSwitchInsn(StringSwitchImpl.this.defaultBlock.getTop(), keys, labelArray);
                for (BytecodeCreatorImpl lookupBlock : lookupBlocks) {
                    lookupBlock.writeOperations(methodVisitor);
                }
                for (BytecodeCreatorImpl caseBlock : StringSwitchImpl.this.caseBlocks.values()) {
                    caseBlock.writeOperations(methodVisitor);
                }
                StringSwitchImpl.this.defaultBlock.writeOperations(methodVisitor);
            }

            @Override
            ResultHandle getTopResultHandle() {
                return null;
            }

            @Override
            ResultHandle getOutgoingResultHandle() {
                return null;
            }

            @Override
            Set<ResultHandle> getInputResultHandles() {
                return inputHandles;
            }
        });
    }

    @Override
    public void caseOf(String value, Consumer<BytecodeCreator> caseBlockConsumer) {
        Objects.requireNonNull(value);
        Objects.requireNonNull(caseBlockConsumer);
        this.addCaseBlock(value, caseBlockConsumer);
    }

    @Override
    public void caseOf(List<String> values, Consumer<BytecodeCreator> caseBlockConsumer) {
        Objects.requireNonNull(values);
        Objects.requireNonNull(caseBlockConsumer);
        Iterator<String> it = values.iterator();
        while (it.hasNext()) {
            String s = it.next();
            if (it.hasNext()) {
                this.addCaseBlock(s, null);
                continue;
            }
            this.addCaseBlock(s, caseBlockConsumer);
        }
    }

    @Override
    void findActiveResultHandles(Set<ResultHandle> handlesToAllocate) {
        super.findActiveResultHandles(handlesToAllocate);
        for (BytecodeCreatorImpl caseBlock : this.caseBlocks.values()) {
            if (caseBlock == null) continue;
            caseBlock.findActiveResultHandles(handlesToAllocate);
        }
        this.defaultBlock.findActiveResultHandles(handlesToAllocate);
    }

    private void addCaseBlock(String value, Consumer<BytecodeCreator> blockConsumer) {
        if (this.caseBlocks.containsKey(value)) {
            throw new IllegalArgumentException("A case block for the string value [" + value + "] already exists");
        }
        BytecodeCreatorImpl caseBlock = null;
        if (blockConsumer != null) {
            caseBlock = new BytecodeCreatorImpl(this);
            blockConsumer.accept(caseBlock);
        }
        this.caseBlocks.put(value, caseBlock);
    }
}

