/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.alias;

import java.util.List;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.completer.CompleterInvocation;
import org.aesh.command.completer.OptionCompleter;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.option.Arguments;
import org.aesh.command.option.Option;
import org.aesh.readline.alias.AliasManager;

@CommandDefinition(name="alias", aliases={"unalias"}, description="")
public class AliasCommand
implements Command<CommandInvocation> {
    @Option(shortName=112, hasValue=false, description="display help information")
    private boolean print;
    @Arguments(completer=AliasCompletor.class)
    private List<String> arguments;
    private final AliasManager manager;

    public AliasCommand(AliasManager manager) {
        this.manager = manager;
    }

    public AliasManager manager() {
        return this.manager;
    }

    @Override
    public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
        String out;
        if (this.print || this.arguments == null || this.arguments.size() == 0) {
            String out2 = this.manager.printAllAliases();
            if (out2 != null && out2.length() > 0) {
                commandInvocation.println(out2);
            }
        } else if (this.arguments.size() == 1 && (out = this.manager.parseAlias("alias " + this.arguments.get(0))) != null && out.length() > 0) {
            commandInvocation.println(out);
        }
        return CommandResult.SUCCESS;
    }

    public static class AliasCompletor
    implements OptionCompleter<CompleterInvocation> {
        @Override
        public void complete(CompleterInvocation completerInvocation) {
            if (completerInvocation.getCommand() instanceof AliasCommand) {
                AliasManager manager = ((AliasCommand)completerInvocation.getCommand()).manager();
                if (completerInvocation.getGivenCompleteValue() == null || completerInvocation.getGivenCompleteValue().length() == 0) {
                    completerInvocation.addAllCompleterValues(manager.findAllMatchingNames(""));
                } else {
                    completerInvocation.addAllCompleterValues(manager.findAllMatchingNames(completerInvocation.getGivenCompleteValue()));
                }
            }
        }
    }
}

