/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.permission;

import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import org.wildfly.security.permission.AbstractPermissionCollection;
import org.wildfly.security.permission.PermissionUtil;

final class SerializedPermissionCollection
implements Serializable {
    private static final long serialVersionUID = -8745428905589938281L;
    private final Permission s;
    private final Permission[] p;
    private final boolean r;

    SerializedPermissionCollection(AbstractPermissionCollection collection) {
        this.s = collection.getSourcePermission();
        ArrayList list = new ArrayList(collection.size());
        collection.forEach(list::add);
        this.p = list.toArray(PermissionUtil.NO_PERMISSIONS);
        this.r = collection.isReadOnly();
    }

    Object readResolve() {
        PermissionCollection collection = this.s.newPermissionCollection();
        for (Permission permission : this.p) {
            collection.add(permission);
        }
        if (this.r) {
            collection.setReadOnly();
        }
        return collection;
    }
}

