/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers.spies;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.groups.MultiOverflowStrategy;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.spies.MultiSpyBase;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class MultiOnOverflowSpy<T>
extends MultiSpyBase<T> {
    private final List<T> droppedItems;
    private final Function<MultiOverflowStrategy<? extends T>, Multi<? extends T>> strategyMapper;

    public List<T> droppedItems() {
        if (this.droppedItems != null) {
            List<T> view = Collections.synchronizedList(this.droppedItems);
            return view;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        super.reset();
        if (this.droppedItems != null) {
            List<T> list = this.droppedItems;
            synchronized (list) {
                this.droppedItems.clear();
            }
        }
    }

    MultiOnOverflowSpy(Multi<? extends T> upstream, boolean trackItems, Function<MultiOverflowStrategy<? extends T>, Multi<? extends T>> strategyMapper) {
        super(upstream);
        this.strategyMapper = strategyMapper;
        this.droppedItems = trackItems ? new ArrayList<T>() : null;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        Multi<? extends T> wrapper = this.strategyMapper.apply(this.upstream.onOverflow().invoke((T item) -> {
            this.incrementInvocationCount();
            if (this.droppedItems != null) {
                List<T> list = this.droppedItems;
                synchronized (list) {
                    this.droppedItems.add(item);
                }
            }
        }));
        ParameterValidation.nonNull(wrapper, "wrapper").subscribe().withSubscriber(downstream);
    }

    @Override
    public String toString() {
        return "MultiOnItemSpy{items=" + String.valueOf(this.droppedItems) + "} " + super.toString();
    }
}

