/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow.conditions.expression;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.workflow.WorkflowConditionProvider;
import org.keycloak.models.workflow.WorkflowConditionProviderFactory;
import org.keycloak.models.workflow.WorkflowsManager;
import org.keycloak.models.workflow.conditions.expression.BooleanConditionBaseVisitor;
import org.keycloak.models.workflow.conditions.expression.BooleanConditionParser;

public class PredicateConditionEvaluator
extends BooleanConditionBaseVisitor<Predicate> {
    private final KeycloakSession session;
    private final CriteriaBuilder cb;
    private final CriteriaQuery<String> query;
    private final Root<?> root;
    private WorkflowsManager manager;

    public PredicateConditionEvaluator(KeycloakSession session, CriteriaBuilder cb, CriteriaQuery<String> query, Root<?> root) {
        this.session = session;
        this.cb = cb;
        this.query = query;
        this.root = root;
        this.manager = new WorkflowsManager(session);
    }

    @Override
    public Predicate visitExpression(BooleanConditionParser.ExpressionContext ctx) {
        if (ctx.OR() != null) {
            Predicate left = (Predicate)this.visit((ParseTree)ctx.expression());
            Predicate right = (Predicate)this.visit((ParseTree)ctx.andExpression());
            return this.cb.or((Expression)left, (Expression)right);
        }
        return (Predicate)this.visit((ParseTree)ctx.andExpression());
    }

    @Override
    public Predicate visitAndExpression(BooleanConditionParser.AndExpressionContext ctx) {
        if (ctx.AND() != null) {
            Predicate left = (Predicate)this.visit((ParseTree)ctx.andExpression());
            Predicate right = (Predicate)this.visit((ParseTree)ctx.notExpression());
            return this.cb.and((Expression)left, (Expression)right);
        }
        return (Predicate)this.visit((ParseTree)ctx.notExpression());
    }

    @Override
    public Predicate visitNotExpression(BooleanConditionParser.NotExpressionContext ctx) {
        if (ctx.NOT() != null) {
            return this.cb.not((Expression)this.visit((ParseTree)ctx.notExpression()));
        }
        return (Predicate)this.visit((ParseTree)ctx.atom());
    }

    @Override
    public Predicate visitAtom(BooleanConditionParser.AtomContext ctx) {
        if (ctx.conditionCall() != null) {
            return (Predicate)this.visit((ParseTree)ctx.conditionCall());
        }
        return (Predicate)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public Predicate visitConditionCall(BooleanConditionParser.ConditionCallContext ctx) {
        String conditionName = ctx.Identifier().getText();
        WorkflowConditionProviderFactory providerFactory = this.manager.getConditionProviderFactory(conditionName);
        WorkflowConditionProvider conditionProvider = providerFactory.create(this.session, this.extractParameterList(ctx.parameterList()));
        return conditionProvider.toPredicate(this.cb, this.query, this.root);
    }

    private List<String> extractParameterList(BooleanConditionParser.ParameterListContext ctx) {
        if (ctx == null) {
            return List.of();
        }
        return ctx.StringLiteral().stream().map(this::visitStringLiteral).collect(Collectors.toList());
    }

    private String visitStringLiteral(ParseTree ctx) {
        String text = ctx.getText();
        return text.substring(1, text.length() - 1).replace("\"\"", "\"");
    }
}

