/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow.conditions;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Subquery;
import java.util.List;
import java.util.stream.Stream;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.jpa.entities.FederatedIdentityEntity;
import org.keycloak.models.workflow.ResourceType;
import org.keycloak.models.workflow.WorkflowConditionProvider;
import org.keycloak.models.workflow.WorkflowEvent;
import org.keycloak.models.workflow.WorkflowInvalidStateException;

public class IdentityProviderWorkflowConditionProvider
implements WorkflowConditionProvider {
    private final List<String> expectedAliases;
    private final KeycloakSession session;

    public IdentityProviderWorkflowConditionProvider(KeycloakSession session, List<String> expectedAliases) {
        this.session = session;
        this.expectedAliases = expectedAliases;
    }

    public boolean evaluate(WorkflowEvent event) {
        if (!ResourceType.USERS.equals((Object)event.getResourceType())) {
            return false;
        }
        this.validate();
        String userId = event.getResourceId();
        RealmModel realm = this.session.getContext().getRealm();
        UserModel user = this.session.users().getUserById(realm, userId);
        Stream federatedIdentities = this.session.users().getFederatedIdentitiesStream(realm, user);
        return federatedIdentities.map(FederatedIdentityModel::getIdentityProvider).anyMatch(this.expectedAliases::contains);
    }

    public Predicate toPredicate(CriteriaBuilder cb, CriteriaQuery<String> query, Root<?> path) {
        Subquery subquery = query.subquery(Integer.class);
        Root from = subquery.from(FederatedIdentityEntity.class);
        subquery.select(cb.literal((Object)1));
        subquery.where((Expression)cb.and((Expression)cb.equal((Expression)from.get("user").get("id"), (Expression)path.get("id")), (Expression)from.get("identityProvider").in(this.expectedAliases)));
        return cb.exists(subquery);
    }

    public void validate() {
        this.expectedAliases.forEach(alias -> {
            if (this.session.identityProviders().getByAlias(alias) == null) {
                throw new WorkflowInvalidStateException(String.format("Identity provider %s does not exist.", alias));
            }
        });
    }

    public void close() {
    }
}

