/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa;

import jakarta.persistence.EntityManagerFactory;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.stat.CollectionStatistics;
import org.hibernate.stat.EntityStatistics;
import org.hibernate.stat.QueryStatistics;
import org.hibernate.stat.Statistics;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.timer.ScheduledTask;

public class HibernateStatsReporter
implements ScheduledTask {
    private static final int LIMIT = 100;
    private final EntityManagerFactory emf;
    private static final Logger logger = Logger.getLogger(HibernateStatsReporter.class);

    public HibernateStatsReporter(EntityManagerFactory emf) {
        this.emf = emf;
    }

    public void run(KeycloakSession session) {
        SessionFactoryImpl sessionFactory = (SessionFactoryImpl)this.emf;
        Statistics stats = sessionFactory.getStatistics();
        this.logStats(stats);
        stats.clear();
    }

    protected void logStats(Statistics stats) {
        String lineSep = System.getProperty("line.separator");
        StringBuilder builder = new StringBuilder(lineSep).append(stats.toString()).append(lineSep).append(lineSep);
        this.logEntities(builder, lineSep, stats);
        this.logCollections(builder, lineSep, stats);
        this.logQueries(builder, lineSep, stats);
        logger.infof(builder.toString(), new Object[0]);
    }

    protected void logEntities(StringBuilder builder, String lineSep, Statistics stats) {
        builder.append("Important entities statistics: ").append(lineSep);
        for (String entity : stats.getEntityNames()) {
            EntityStatistics entityStats = stats.getEntityStatistics(entity);
            if (entityStats.getInsertCount() <= 100L && entityStats.getDeleteCount() <= 100L && entityStats.getUpdateCount() <= 100L && entityStats.getLoadCount() <= 100L && entityStats.getFetchCount() <= 100L) continue;
            builder.append(entity).append(" - ").append("inserted: ").append(entityStats.getInsertCount()).append(", updated: ").append(entityStats.getUpdateCount()).append(", removed: ").append(entityStats.getDeleteCount()).append(", loaded: ").append(entityStats.getLoadCount()).append(", fetched: ").append(entityStats.getFetchCount()).append(lineSep);
        }
        builder.append(lineSep);
    }

    protected void logCollections(StringBuilder builder, String lineSep, Statistics stats) {
        builder.append("Important collections statistics: ").append(lineSep);
        for (String col : stats.getCollectionRoleNames()) {
            CollectionStatistics collectionStats = stats.getCollectionStatistics(col);
            if (collectionStats.getRecreateCount() <= 100L && collectionStats.getUpdateCount() <= 100L && collectionStats.getRemoveCount() <= 100L && collectionStats.getLoadCount() <= 100L && collectionStats.getFetchCount() <= 100L) continue;
            builder.append(col).append(" - ").append("recreated: ").append(collectionStats.getRecreateCount()).append(", updated: ").append(collectionStats.getUpdateCount()).append(", removed: ").append(collectionStats.getRemoveCount()).append(", loaded: ").append(collectionStats.getLoadCount()).append(", fetched: ").append(collectionStats.getFetchCount()).append(lineSep);
        }
        builder.append(lineSep);
    }

    protected void logQueries(StringBuilder builder, String lineSep, Statistics stats) {
        builder.append("Important queries statistics: ").append(lineSep).append(lineSep);
        for (String query : stats.getQueries()) {
            QueryStatistics queryStats = stats.getQueryStatistics(query);
            if (queryStats.getExecutionCount() <= 100L && queryStats.getExecutionCount() * queryStats.getExecutionAvgTime() <= 100L) continue;
            builder.append(query).append(lineSep).append("executionCount=").append(queryStats.getExecutionCount()).append(lineSep).append("executionAvgTime=").append(queryStats.getExecutionAvgTime()).append(" ms").append(lineSep).append(lineSep).append(lineSep);
        }
    }
}

