/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.RealmRepresentation;

public class MigrateTo8_0_2
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("8.0.2");
    private static final Logger LOG = Logger.getLogger(MigrateTo8_0_2.class);

    public ModelVersion getVersion() {
        return VERSION;
    }

    public void migrate(KeycloakSession session) {
        session.realms().getRealmsStream().forEach(this::migrateAuthenticationFlowsWithAlternativeRequirements);
    }

    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        this.migrateAuthenticationFlowsWithAlternativeRequirements(realm);
    }

    protected void migrateAuthenticationFlowsWithAlternativeRequirements(RealmModel realm) {
        for (AuthenticationFlowModel flow : realm.getAuthenticationFlowsStream().collect(Collectors.toList())) {
            List executions = realm.getAuthenticationExecutionsStream(flow.getId()).collect(Collectors.toList());
            Set requirements = executions.stream().map(AuthenticationExecutionModel::getRequirement).collect(Collectors.toSet());
            if (!requirements.contains(AuthenticationExecutionModel.Requirement.REQUIRED) && (!requirements.contains(AuthenticationExecutionModel.Requirement.CONDITIONAL) || !requirements.contains(AuthenticationExecutionModel.Requirement.ALTERNATIVE))) continue;
            AtomicInteger suffix = new AtomicInteger(0);
            LinkedList<AuthenticationExecutionModel> alternativesToMigrate = new LinkedList<AuthenticationExecutionModel>();
            for (AuthenticationExecutionModel execution : executions) {
                if (AuthenticationExecutionModel.Requirement.ALTERNATIVE.equals((Object)execution.getRequirement())) {
                    alternativesToMigrate.add(execution);
                }
                if (!AuthenticationExecutionModel.Requirement.REQUIRED.equals((Object)execution.getRequirement()) && !AuthenticationExecutionModel.Requirement.CONDITIONAL.equals((Object)execution.getRequirement()) || alternativesToMigrate.isEmpty()) continue;
                this.migrateAlternatives(realm, flow, alternativesToMigrate, suffix.get());
                suffix.addAndGet(1);
                alternativesToMigrate.clear();
            }
            if (alternativesToMigrate.isEmpty()) continue;
            this.migrateAlternatives(realm, flow, alternativesToMigrate, suffix.get());
        }
    }

    private void migrateAlternatives(RealmModel realm, AuthenticationFlowModel parentFlow, LinkedList<AuthenticationExecutionModel> alternativesToMigrate, int suffix) {
        LOG.debugf("Migrating %d ALTERNATIVE executions in the flow '%s' of realm '%s' to separate subflow", alternativesToMigrate.size(), (Object)parentFlow.getAlias(), (Object)realm.getName());
        AuthenticationFlowModel newFlow = new AuthenticationFlowModel();
        newFlow.setTopLevel(false);
        newFlow.setBuiltIn(parentFlow.isBuiltIn());
        newFlow.setAlias(parentFlow.getAlias() + " - Alternatives - " + suffix);
        newFlow.setDescription("Subflow of " + parentFlow.getAlias() + " with alternative executions");
        newFlow.setProviderId("basic-flow");
        newFlow = realm.addAuthenticationFlow(newFlow);
        AuthenticationExecutionModel execution = new AuthenticationExecutionModel();
        execution.setParentFlow(parentFlow.getId());
        execution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED);
        execution.setFlowId(newFlow.getId());
        execution.setPriority(alternativesToMigrate.getFirst().getPriority());
        execution.setAuthenticatorFlow(true);
        realm.addAuthenticatorExecution(execution);
        int priority = 0;
        for (AuthenticationExecutionModel ex : alternativesToMigrate) {
            ex.setParentFlow(newFlow.getId());
            ex.setPriority(priority += 10);
            realm.updateAuthenticatorExecution(ex);
        }
    }
}

