/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.DefaultAuthenticationFlows;
import org.keycloak.representations.idm.RealmRepresentation;

public class MigrateTo3_2_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("3.2.0");

    public void migrate(KeycloakSession session) {
        session.realms().getRealmsStream().forEach(realm -> this.migrateRealm(session, (RealmModel)realm));
    }

    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        this.migrateRealm(session, realm);
    }

    protected void migrateRealm(KeycloakSession session, RealmModel realm) {
        ClientModel masterAdminClient;
        ClientModel realmAccess;
        PasswordPolicy.Builder builder = realm.getPasswordPolicy().toBuilder();
        if (!builder.contains("hashAlgorithm") && "20000".equals(builder.get("hashIterations"))) {
            realm.setPasswordPolicy(builder.remove("hashIterations").build(session));
        }
        if (realm.getDockerAuthenticationFlow() == null) {
            DefaultAuthenticationFlows.dockerAuthenticationFlow((RealmModel)realm);
        }
        if ((realmAccess = realm.getClientByClientId("realm-management")) != null) {
            this.addRoles(realmAccess);
        }
        if ((masterAdminClient = realm.getMasterAdminClient()) != null) {
            this.addRoles(masterAdminClient);
        }
    }

    public void addRoles(ClientModel realmAccess) {
        RoleModel viewUsers;
        RoleModel queryGroups;
        RoleModel queryUsers;
        RoleModel queryClients = realmAccess.getRole("query-clients");
        if (queryClients == null) {
            queryClients = realmAccess.addRole("query-clients");
            RoleModel viewClients = realmAccess.getRole("view-clients");
            if (viewClients != null) {
                viewClients.addCompositeRole(queryClients);
            }
        }
        if ((queryUsers = realmAccess.getRole("query-users")) == null) {
            queryUsers = realmAccess.addRole("query-users");
        }
        if ((queryGroups = realmAccess.getRole("query-groups")) == null) {
            queryGroups = realmAccess.addRole("query-groups");
        }
        if ((viewUsers = realmAccess.getRole("view-users")) != null) {
            if (!viewUsers.hasRole(queryUsers)) {
                viewUsers.addCompositeRole(queryUsers);
            }
            if (!viewUsers.hasRole(queryGroups)) {
                viewUsers.addCompositeRole(queryGroups);
            }
        }
    }

    public ModelVersion getVersion() {
        return VERSION;
    }
}

