/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import org.jboss.logging.Logger;
import org.keycloak.migration.MigrationProvider;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.RealmMigration;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public class MigrateTo25_0_0
extends RealmMigration {
    public static final ModelVersion VERSION = new ModelVersion("25.0.0");
    private static final Logger LOG = Logger.getLogger(MigrateTo25_0_0.class);

    public ModelVersion getVersion() {
        return VERSION;
    }

    @Override
    public void migrate(KeycloakSession session) {
        if (session.sessions() != null) {
            session.sessions().migrate(VERSION.toString());
        }
        super.migrate(session);
    }

    @Override
    public void migrateRealm(KeycloakSession session, RealmModel realm) {
        MigrationProvider migrationProvider = (MigrationProvider)session.getProvider(MigrationProvider.class);
        ClientScopeModel basicScope = KeycloakModelUtils.getClientScopeByName((RealmModel)realm, (String)"basic");
        if (basicScope == null) {
            basicScope = migrationProvider.addOIDCBasicClientScope(realm);
            session.clients().addClientScopeToAllClients(realm, basicScope, true);
        } else {
            LOG.warnf("Client scope '%s' already exists in the realm '%s'. Please migrate this realm manually if you need basic claims in your tokens.", (Object)basicScope.getName(), (Object)realm.getName());
        }
    }
}

