/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.impl;

import io.github.dmlloyd.classfile.Attribute;
import io.github.dmlloyd.classfile.AttributeMapper;
import io.github.dmlloyd.classfile.Attributes;
import io.github.dmlloyd.classfile.BufWriter;
import io.github.dmlloyd.classfile.ClassFile;
import io.github.dmlloyd.classfile.ClassModel;
import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.CustomAttribute;
import io.github.dmlloyd.classfile.FieldBuilder;
import io.github.dmlloyd.classfile.MethodBuilder;
import io.github.dmlloyd.classfile.Opcode;
import io.github.dmlloyd.classfile.PseudoInstruction;
import io.github.dmlloyd.classfile.attribute.CodeAttribute;
import io.github.dmlloyd.classfile.components.ClassPrinter;
import io.github.dmlloyd.classfile.constantpool.ClassEntry;
import io.github.dmlloyd.classfile.constantpool.ModuleEntry;
import io.github.dmlloyd.classfile.constantpool.PoolEntry;
import io.github.dmlloyd.classfile.constantpool.Utf8Entry;
import io.github.dmlloyd.classfile.extras.constant.ExtraClassDesc;
import io.github.dmlloyd.classfile.extras.constant.ModuleDesc;
import io.github.dmlloyd.classfile.extras.reflect.AccessFlag;
import io.github.dmlloyd.classfile.impl.AbstractPoolEntry;
import io.github.dmlloyd.classfile.impl.BoundAttribute;
import io.github.dmlloyd.classfile.impl.BufWriterImpl;
import io.github.dmlloyd.classfile.impl.ClassFileImpl;
import io.github.dmlloyd.classfile.impl.DirectMethodBuilder;
import io.github.dmlloyd.classfile.impl.RawBytecodeHelper;
import io.github.dmlloyd.classfile.impl.SplitConstantPool;
import io.github.dmlloyd.classfile.impl.TemporaryConstantPool;
import io.github.dmlloyd.classfile.impl.UnboundAttribute;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public class Util {
    private static final int ATTRIBUTE_STABILITY_COUNT = AttributeMapper.AttributeStability.values().length;
    static final int INVERSE_31 = -1108378657;
    static final int SIGNIFICANT_OCTAL_DIGITS = 6;
    static final int[] powers = new int[]{31, 961, 29791, 923521, 28629151, 887503681, 1742810335, -1807454463, 1353309697, -2077209343, 2111290369, -1935660287, -7759359, 630458625, 1304393729, -474025983, -1040291839, -394403839, 1463638017, 238866433, 226248705, 1425784833, -1174962175, 787693569, -1276182527, 1223344129, -303661055, -1562230783, 1742602241, -809762815, 932839425, -1619525631, 123076609, 1865678849, -686686207, 1055916033, 2111832065, -1127219199, -71303167, 984612865, 2040528897, -1198522367, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    private Util() {
    }

    public static <T> Consumer<Consumer<T>> writingAll(Iterable<T> container) {
        record ForEachConsumer<T>(Iterable<T> container) implements Consumer<Consumer<T>>
        {
            @Override
            public void accept(Consumer<T> consumer) {
                this.container.forEach(consumer);
            }
        }
        return new ForEachConsumer<T>(container);
    }

    public static Consumer<MethodBuilder> buildingCode(Consumer<? super CodeBuilder> codeHandler) {
        record WithCodeMethodHandler(Consumer<? super CodeBuilder> codeHandler) implements Consumer<MethodBuilder>
        {
            @Override
            public void accept(MethodBuilder builder) {
                builder.withCode(this.codeHandler);
            }
        }
        return new WithCodeMethodHandler(codeHandler);
    }

    public static Consumer<FieldBuilder> buildingFlags(int flags) {
        record WithFlagFieldHandler(int flags) implements Consumer<FieldBuilder>
        {
            @Override
            public void accept(FieldBuilder builder) {
                builder.withFlags(this.flags);
            }
        }
        return new WithFlagFieldHandler(flags);
    }

    public static boolean isAttributeAllowed(Attribute<?> attr, ClassFileImpl context) {
        return attr instanceof BoundAttribute ? ATTRIBUTE_STABILITY_COUNT - attr.attributeMapper().stability().ordinal() > context.attributesProcessingOption().ordinal() : true;
    }

    public static int parameterSlots(MethodTypeDesc mDesc) {
        int count = mDesc.parameterCount();
        for (int i = count - 1; i >= 0; --i) {
            if (!Util.isDoubleSlot(mDesc.parameterType(i))) continue;
            ++count;
        }
        return count;
    }

    public static int[] parseParameterSlots(int flags, MethodTypeDesc mDesc) {
        int[] result = new int[mDesc.parameterCount()];
        int count = (flags & 8) != 0 ? 0 : 1;
        for (int i = 0; i < result.length; ++i) {
            result[i] = count;
            count += Util.paramSlotSize(mDesc.parameterType(i));
        }
        return result;
    }

    public static int maxLocals(int flags, MethodTypeDesc mDesc) {
        return Util.parameterSlots(mDesc) + ((flags & 8) == 0 ? 1 : 0);
    }

    public static String toBinaryName(ClassDesc cd) {
        return Util.toInternalName(cd).replace('/', '.');
    }

    public static String toInternalName(ClassDesc cd) {
        if (cd.isClassOrInterface()) {
            String desc = cd.descriptorString();
            return desc.substring(1, desc.length() - 1);
        }
        throw new IllegalArgumentException(cd.descriptorString());
    }

    public static ClassDesc toClassDesc(String classInternalNameOrArrayDesc) {
        return classInternalNameOrArrayDesc.charAt(0) == '[' ? ClassDesc.ofDescriptor(classInternalNameOrArrayDesc) : ExtraClassDesc.ofInternalName(classInternalNameOrArrayDesc);
    }

    public static <T, U> List<U> mappedList(final List<? extends T> list, final Function<T, U> mapper) {
        return new AbstractList<U>(){

            @Override
            public U get(int index) {
                return mapper.apply(list.get(index));
            }

            @Override
            public int size() {
                return list.size();
            }
        };
    }

    public static List<ClassEntry> entryList(List<? extends ClassDesc> list) {
        return list.stream().map(TemporaryConstantPool.INSTANCE::classEntry).toList();
    }

    public static List<ModuleEntry> moduleEntryList(List<? extends ModuleDesc> list) {
        return list.stream().map(ModuleDesc::name).map(TemporaryConstantPool.INSTANCE::utf8Entry).map(TemporaryConstantPool.INSTANCE::moduleEntry).toList();
    }

    public static void checkKind(Opcode op, Opcode.Kind k) {
        if (op.kind() != k) {
            throw Util.badOpcodeKindException(op, k);
        }
    }

    public static IllegalArgumentException badOpcodeKindException(Opcode op, Opcode.Kind k) {
        return new IllegalArgumentException(String.format("Wrong opcode kind specified; found %s(%s), expected %s", new Object[]{op, op.kind(), k}));
    }

    public static int flagsToBits(AccessFlag.Location location, Collection<AccessFlag> flags) {
        int i = 0;
        for (AccessFlag f : flags) {
            if (!f.locations().contains((Object)location)) {
                throw new IllegalArgumentException("unexpected flag: " + f + " use in target location: " + location);
            }
            i |= f.mask();
        }
        return i;
    }

    public static int flagsToBits(AccessFlag.Location location, AccessFlag ... flags) {
        int i = 0;
        for (AccessFlag f : flags) {
            if (!f.locations().contains((Object)location)) {
                throw new IllegalArgumentException("unexpected flag: " + f + " use in target location: " + location);
            }
            i |= f.mask();
        }
        return i;
    }

    public static boolean has(AccessFlag.Location location, int flagsMask, AccessFlag flag) {
        return (flag.mask() & flagsMask) == flag.mask() && flag.locations().contains((Object)location);
    }

    public static ClassDesc fieldTypeSymbol(Utf8Entry utf8) {
        return ((AbstractPoolEntry.Utf8EntryImpl)utf8).fieldTypeSymbol();
    }

    public static MethodTypeDesc methodTypeSymbol(Utf8Entry utf8) {
        return ((AbstractPoolEntry.Utf8EntryImpl)utf8).methodTypeSymbol();
    }

    public static <T extends Attribute<T>> void writeAttribute(BufWriterImpl writer, Attribute<?> attr) {
        if (attr instanceof CustomAttribute) {
            CustomAttribute ca = (CustomAttribute)attr;
            AttributeMapper mapper = ca.attributeMapper();
            mapper.writeAttribute(writer, ca);
        } else {
            assert (attr instanceof BoundAttribute || attr instanceof UnboundAttribute);
            ((Writable)((Object)attr)).writeTo(writer);
        }
    }

    public static void writeAttributes(BufWriterImpl buf, List<? extends Attribute<?>> list) {
        int size = list.size();
        buf.writeU2(size);
        for (int i = 0; i < size; ++i) {
            Util.writeAttribute(buf, list.get(i));
        }
    }

    static void writeList(BufWriterImpl buf, Writable[] array, int size) {
        buf.writeU2(size);
        for (int i = 0; i < size; ++i) {
            array[i].writeTo(buf);
        }
    }

    public static int slotSize(ClassDesc desc) {
        return desc.equals(ConstantDescs.CD_void) ? 0 : (Util.isDoubleSlot(desc) ? 2 : 1);
    }

    public static int paramSlotSize(ClassDesc desc) {
        return Util.isDoubleSlot(desc) ? 2 : 1;
    }

    public static boolean isDoubleSlot(ClassDesc desc) {
        return desc.equals(ConstantDescs.CD_double) || desc.equals(ConstantDescs.CD_long);
    }

    public static void dumpMethod(final SplitConstantPool cp, ClassDesc cls, String methodName, MethodTypeDesc methodDesc, int acc, final RawBytecodeHelper.CodeRange bytecode, Consumer<String> dump) {
        try {
            ClassFile cc = ClassFile.of();
            ClassModel clm = cc.parse(cc.build(cp.classEntry(cls), cp, clb -> clb.withMethod(methodName, methodDesc, acc, mb -> ((DirectMethodBuilder)mb).writeAttribute(new UnboundAttribute.AdHocAttribute<CodeAttribute>(Attributes.code()){

                @Override
                public void writeBody(BufWriterImpl b) {
                    b.writeU2U2(-1, -1);
                    b.writeInt(bytecode.length());
                    b.writeBytes(bytecode.array(), 0, bytecode.length());
                    b.writeU2U2(0, 0);
                }

                @Override
                public Utf8Entry attributeName() {
                    return cp.utf8Entry("Code");
                }
            }))));
            ClassPrinter.toYaml(clm.methods().get(0).code().get(), ClassPrinter.Verbosity.TRACE_ALL, dump);
        }
        catch (Error | Exception __) {
            Util.dumpBytesHex(dump, bytecode.array(), bytecode.length());
        }
    }

    public static void dumpBytesHex(Consumer<String> dump, byte[] bytes, int length) {
        for (int i = 0; i < length; ++i) {
            if (i % 16 == 0) {
                dump.accept("%n%04x:".formatted(i));
            }
            dump.accept(" %02x".formatted(bytes[i]));
        }
    }

    public static void writeListIndices(BufWriter writer, List<? extends PoolEntry> list) {
        writer.writeU2(list.size());
        for (PoolEntry poolEntry : list) {
            writer.writeIndex(poolEntry);
        }
    }

    public static boolean writeLocalVariable(BufWriterImpl buf, PseudoInstruction lvOrLvt) {
        return ((WritableLocalVariable)((Object)lvOrLvt)).writeLocalTo(buf);
    }

    public static int descriptorStringHash(int length, int hash) {
        if (length > 65535) {
            throw new IllegalArgumentException("String too long: ".concat(Integer.toString(length)));
        }
        return 76 * Util.pow31(length + 1) + hash * 31 + 59;
    }

    public static int pow31(int k) {
        int r = 1;
        for (int i = 0; i < 6; ++i) {
            r *= Util.powerOctal(k & 7, i);
            k >>= 3;
        }
        return r;
    }

    static int powersIndex(int digit, int index) {
        return digit - 1 + index * 7;
    }

    private static int powerOctal(int digit, int index) {
        return digit == 0 ? 1 : powers[Util.powersIndex(digit, index) & 0x3F];
    }

    static interface Writable {
        public void writeTo(BufWriterImpl var1);
    }

    static interface WritableLocalVariable {
        public boolean writeLocalTo(BufWriterImpl var1);
    }
}

