/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.attribute;

import io.github.dmlloyd.classfile.Attribute;
import io.github.dmlloyd.classfile.ClassElement;
import io.github.dmlloyd.classfile.ClassSignature;
import io.github.dmlloyd.classfile.FieldElement;
import io.github.dmlloyd.classfile.MethodElement;
import io.github.dmlloyd.classfile.MethodSignature;
import io.github.dmlloyd.classfile.Signature;
import io.github.dmlloyd.classfile.constantpool.Utf8Entry;
import io.github.dmlloyd.classfile.impl.TemporaryConstantPool;
import io.github.dmlloyd.classfile.impl.UnboundAttribute;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface SignatureAttribute
extends Attribute<SignatureAttribute>,
ClassElement,
MethodElement,
FieldElement {
    public Utf8Entry signature();

    default public ClassSignature asClassSignature() {
        return ClassSignature.parseFrom(this.signature().stringValue());
    }

    default public MethodSignature asMethodSignature() {
        return MethodSignature.parseFrom(this.signature().stringValue());
    }

    default public Signature asTypeSignature() {
        return Signature.parseFrom(this.signature().stringValue());
    }

    public static SignatureAttribute of(ClassSignature classSignature) {
        return SignatureAttribute.of(TemporaryConstantPool.INSTANCE.utf8Entry(classSignature.signatureString()));
    }

    public static SignatureAttribute of(MethodSignature methodSignature) {
        return SignatureAttribute.of(TemporaryConstantPool.INSTANCE.utf8Entry(methodSignature.signatureString()));
    }

    public static SignatureAttribute of(Signature signature) {
        return SignatureAttribute.of(TemporaryConstantPool.INSTANCE.utf8Entry(signature.signatureString()));
    }

    public static SignatureAttribute of(Utf8Entry signature) {
        return new UnboundAttribute.UnboundSignatureAttribute(signature);
    }
}

