/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile;

import io.github.dmlloyd.classfile.ClassElement;
import io.github.dmlloyd.classfile.ClassFileBuilder;
import io.github.dmlloyd.classfile.ClassFileVersion;
import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.FieldBuilder;
import io.github.dmlloyd.classfile.FieldModel;
import io.github.dmlloyd.classfile.FieldTransform;
import io.github.dmlloyd.classfile.Interfaces;
import io.github.dmlloyd.classfile.MethodBuilder;
import io.github.dmlloyd.classfile.MethodModel;
import io.github.dmlloyd.classfile.MethodTransform;
import io.github.dmlloyd.classfile.Superclass;
import io.github.dmlloyd.classfile.constantpool.ClassEntry;
import io.github.dmlloyd.classfile.constantpool.Utf8Entry;
import io.github.dmlloyd.classfile.extras.reflect.AccessFlag;
import io.github.dmlloyd.classfile.impl.AccessFlagsImpl;
import io.github.dmlloyd.classfile.impl.Util;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ClassBuilder
extends ClassFileBuilder<ClassElement, ClassBuilder> {
    default public ClassBuilder withVersion(int major, int minor) {
        return (ClassBuilder)this.with(ClassFileVersion.of(major, minor));
    }

    default public ClassBuilder withFlags(int flags) {
        return (ClassBuilder)this.with(new AccessFlagsImpl(AccessFlag.Location.CLASS, flags));
    }

    default public ClassBuilder withFlags(AccessFlag ... flags) {
        return (ClassBuilder)this.with(new AccessFlagsImpl(AccessFlag.Location.CLASS, flags));
    }

    default public ClassBuilder withSuperclass(ClassEntry superclassEntry) {
        return (ClassBuilder)this.with(Superclass.of(superclassEntry));
    }

    default public ClassBuilder withSuperclass(ClassDesc desc) {
        return this.withSuperclass(this.constantPool().classEntry(desc));
    }

    default public ClassBuilder withInterfaces(List<ClassEntry> interfaces) {
        return (ClassBuilder)this.with(Interfaces.of(interfaces));
    }

    default public ClassBuilder withInterfaces(ClassEntry ... interfaces) {
        return this.withInterfaces(List.of(interfaces));
    }

    default public ClassBuilder withInterfaceSymbols(List<ClassDesc> interfaces) {
        return this.withInterfaces(Util.entryList(interfaces));
    }

    default public ClassBuilder withInterfaceSymbols(ClassDesc ... interfaces) {
        return this.withInterfaceSymbols(Arrays.asList(interfaces));
    }

    public ClassBuilder withField(Utf8Entry var1, Utf8Entry var2, Consumer<? super FieldBuilder> var3);

    default public ClassBuilder withField(Utf8Entry name, Utf8Entry descriptor, int flags) {
        return this.withField(name, descriptor, Util.buildingFlags(flags));
    }

    default public ClassBuilder withField(String name, ClassDesc descriptor, Consumer<? super FieldBuilder> handler) {
        return this.withField(this.constantPool().utf8Entry(name), this.constantPool().utf8Entry(descriptor), handler);
    }

    default public ClassBuilder withField(String name, ClassDesc descriptor, int flags) {
        return this.withField(this.constantPool().utf8Entry(name), this.constantPool().utf8Entry(descriptor), flags);
    }

    public ClassBuilder transformField(FieldModel var1, FieldTransform var2);

    public ClassBuilder withMethod(Utf8Entry var1, Utf8Entry var2, int var3, Consumer<? super MethodBuilder> var4);

    default public ClassBuilder withMethodBody(Utf8Entry name, Utf8Entry descriptor, int methodFlags, Consumer<? super CodeBuilder> handler) {
        return this.withMethod(name, descriptor, methodFlags, Util.buildingCode(handler));
    }

    default public ClassBuilder withMethod(String name, MethodTypeDesc descriptor, int methodFlags, Consumer<? super MethodBuilder> handler) {
        return this.withMethod(this.constantPool().utf8Entry(name), this.constantPool().utf8Entry(descriptor), methodFlags, handler);
    }

    default public ClassBuilder withMethodBody(String name, MethodTypeDesc descriptor, int methodFlags, Consumer<? super CodeBuilder> handler) {
        return this.withMethod(name, descriptor, methodFlags, Util.buildingCode(handler));
    }

    public ClassBuilder transformMethod(MethodModel var1, MethodTransform var2);
}

