/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.vertx.codegen.methods;

import io.vertx.codegen.MethodInfo;
import java.util.Set;

public class MutinyMethodDescriptor {
    private static final Set<String> NON_DEPRECATED_METHODS = Set.of("executeBlocking");
    public final boolean fluent;
    private final MutinyKind kind;
    private final MethodInfo method;
    private final MethodInfo original;
    private final boolean isPrivate;

    public static MutinyMethodDescriptor createAndForgetMethod(MethodInfo method, MethodInfo delegate, boolean fluent) {
        return new MutinyMethodDescriptor(method, delegate, MutinyKind.FORGET, fluent);
    }

    public MutinyMethodDescriptor(MethodInfo method, MethodInfo original, MutinyKind kind, boolean fluent) {
        this(method, original, kind, fluent, false);
    }

    public MutinyMethodDescriptor(MethodInfo method, MethodInfo original, MutinyKind kind, boolean fluent, boolean isPrivate) {
        this.kind = kind;
        this.fluent = fluent;
        this.method = method;
        this.original = original;
        this.isPrivate = isPrivate;
    }

    public MutinyMethodDescriptor(MethodInfo method, MethodInfo original, MutinyKind kind) {
        this(method, original, kind, false);
    }

    public String getMethodName() {
        return this.method.getName();
    }

    public String getOriginalMethodName() {
        return this.original.getName();
    }

    public MethodInfo getOriginalMethod() {
        return this.original;
    }

    public MethodInfo getMethod() {
        return this.method;
    }

    public boolean isFluent() {
        return this.fluent;
    }

    public boolean isDeprecated() {
        if (NON_DEPRECATED_METHODS.contains(this.method.getName())) {
            return false;
        }
        return this.method.isDeprecated();
    }

    public boolean isAwaitMethod() {
        return this.kind == MutinyKind.AWAIT;
    }

    public boolean isForgetMethod() {
        return this.kind == MutinyKind.FORGET;
    }

    public boolean isUniMethod() {
        return this.kind == MutinyKind.UNI;
    }

    public boolean isConsumerMethod() {
        return this.kind == MutinyKind.CONSUMER;
    }

    public boolean isSimple() {
        return this.kind == MutinyKind.SIMPLE;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public static enum MutinyKind {
        UNI,
        AWAIT,
        FORGET,
        CONSUMER,
        SIMPLE;

    }
}

