/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport.singlefile;

import java.io.File;
import java.util.List;
import java.util.Objects;
import org.keycloak.Config;
import org.keycloak.exportimport.ExportProvider;
import org.keycloak.exportimport.ExportProviderFactory;
import org.keycloak.exportimport.singlefile.SingleFileExportProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;

public class SingleFileExportProviderFactory
implements ExportProviderFactory {
    public static final String PROVIDER_ID = "singleFile";
    public static final String FILE = "file";
    public static final String REALM_NAME = "realmName";
    private Config.Scope config;

    public ExportProvider create(KeycloakSession session) {
        String fileName = System.getProperty("keycloak.migration.file", this.config.get(FILE));
        Objects.requireNonNull(fileName, "file name not configured");
        String realmName = System.getProperty("keycloak.migration.realmName", this.config.get(REALM_NAME));
        return new SingleFileExportProvider(session.getKeycloakSessionFactory()).withFile(new File(fileName)).withRealmName(realmName);
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name(REALM_NAME).type("string").helpText("Realm to export").add().property().name(FILE).type("string").helpText("File to export to").add().build();
    }
}

