/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport.singlefile;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.exportimport.ExportProvider;
import org.keycloak.exportimport.util.ExportImportSessionTask;
import org.keycloak.exportimport.util.ExportUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.util.ObjectMapperResolver;

public class SingleFileExportProvider
implements ExportProvider {
    private static final Logger logger = Logger.getLogger(SingleFileExportProvider.class);
    private File file;
    private final KeycloakSessionFactory factory;
    private String realmName;

    public SingleFileExportProvider(KeycloakSessionFactory factory) {
        this.factory = factory;
    }

    public SingleFileExportProvider withFile(File file) {
        this.file = file;
        return this;
    }

    public void exportModel() {
        new ExportImportSessionTask(){

            @Override
            protected void runExportImportTask(KeycloakSession session) throws IOException {
                if (SingleFileExportProvider.this.realmName != null) {
                    ServicesLogger.LOGGER.realmExportRequested(SingleFileExportProvider.this.realmName);
                    SingleFileExportProvider.this.exportRealm(session, SingleFileExportProvider.this.realmName);
                } else {
                    ServicesLogger.LOGGER.fullModelExportRequested();
                    logger.infof("Exporting model into file %s", (Object)SingleFileExportProvider.this.file.getAbsolutePath());
                    Stream<RealmRepresentation> realms = session.realms().getRealmsStream().peek(realm -> session.getContext().setRealm(realm)).map(realm -> ExportUtils.exportRealm((KeycloakSession)session, (RealmModel)realm, (boolean)true, (boolean)true));
                    SingleFileExportProvider.this.writeToFile(realms);
                }
            }
        }.runTask(this.factory);
        ServicesLogger.LOGGER.exportSuccess();
    }

    private void exportRealm(KeycloakSession session, String realmName) throws IOException {
        logger.infof("Exporting realm '%s' into file %s", (Object)realmName, (Object)this.file.getAbsolutePath());
        RealmModel realm = session.realms().getRealmByName(realmName);
        Objects.requireNonNull(realm, "realm not found by realm name '" + realmName + "'");
        session.getContext().setRealm(realm);
        RealmRepresentation realmRep = ExportUtils.exportRealm((KeycloakSession)session, (RealmModel)realm, (boolean)true, (boolean)true);
        this.writeToFile(realmRep);
    }

    public void close() {
    }

    private ObjectMapper getObjectMapper() {
        ObjectMapper streamSerializer = ObjectMapperResolver.createStreamSerializer();
        streamSerializer.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        streamSerializer.enable(SerializationFeature.INDENT_OUTPUT);
        return streamSerializer;
    }

    private void writeToFile(Object reps) throws IOException {
        FileOutputStream stream = new FileOutputStream(this.file);
        this.getObjectMapper().writeValue((OutputStream)stream, reps);
    }

    public ExportProvider withRealmName(String realmName) {
        this.realmName = realmName;
        return this;
    }
}

