/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.api;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.intellij.collaboration.api.dto.GraphQLErrorDTO;
import com.intellij.collaboration.api.dto.GraphQLResponseDTO;
import com.intellij.collaboration.api.graphql.GraphQLDataDeserializer;
import com.intellij.collaboration.api.json.JsonDataSerializer;
import java.io.Reader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gitlab.api.GitLabRestJsonDataDeSerializer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016JG\u0010\u000b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u0001H\r\u0012\u0004\u0012\u00020\u000e0\f\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\r0\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016Ja\u0010\u000b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u0001H\r\u0012\u0004\u0012\u00020\u000e0\f\"\u0004\b\u0000\u0010\r2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\r0\u00152 \u0010\u0017\u001a\u001c\u0012\u0004\u0012\u00020\u0019\u0012\u0012\u0012\u0010\u0012\u0006\b\u0001\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u000e0\f0\u0018H\u0002\u00a2\u0006\u0002\u0010\u001bJU\u0010\u001c\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u0001H\r\u0012\u0004\u0012\u00020\u000e0\f\"\u0004\b\u0000\u0010\r2\u0014\u0010\u001d\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u000e0\f2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\r0\u0015H\u0002\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/gitlab/api/GitLabGQLDataDeSerializer;", "Lcom/intellij/collaboration/api/json/JsonDataSerializer;", "Lcom/intellij/collaboration/api/graphql/GraphQLDataDeserializer;", "<init>", "()V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "toJsonBytes", "", "content", "", "readAndMapGQLResponse", "Lcom/intellij/collaboration/api/dto/GraphQLResponseDTO;", "T", "Lcom/intellij/collaboration/api/dto/GraphQLErrorDTO;", "bodyReader", "Ljava/io/Reader;", "pathFromData", "", "", "clazz", "Ljava/lang/Class;", "(Ljava/io/Reader;[Ljava/lang/String;Ljava/lang/Class;)Lcom/intellij/collaboration/api/dto/GraphQLResponseDTO;", "responseSupplier", "Lkotlin/Function1;", "Lcom/fasterxml/jackson/databind/JavaType;", "Lcom/fasterxml/jackson/databind/JsonNode;", "([Ljava/lang/String;Ljava/lang/Class;Lkotlin/jvm/functions/Function1;)Lcom/intellij/collaboration/api/dto/GraphQLResponseDTO;", "mapGQLResponse", "result", "(Lcom/intellij/collaboration/api/dto/GraphQLResponseDTO;[Ljava/lang/String;Ljava/lang/Class;)Lcom/intellij/collaboration/api/dto/GraphQLResponseDTO;", "intellij.vcs.gitlab"})
public final class GitLabGQLDataDeSerializer
implements JsonDataSerializer,
GraphQLDataDeserializer {
    @NotNull
    public static final GitLabGQLDataDeSerializer INSTANCE = new GitLabGQLDataDeSerializer();
    @NotNull
    private static final ObjectMapper mapper;

    private GitLabGQLDataDeSerializer() {
    }

    @NotNull
    public byte[] toJsonBytes(@NotNull Object content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        byte[] byArray = mapper.writeValueAsBytes(content);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"writeValueAsBytes(...)");
        return byArray;
    }

    @NotNull
    public <T> GraphQLResponseDTO<T, GraphQLErrorDTO> readAndMapGQLResponse(@NotNull Reader bodyReader, @NotNull String[] pathFromData, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)bodyReader, (String)"bodyReader");
        Intrinsics.checkNotNullParameter((Object)pathFromData, (String)"pathFromData");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return this.readAndMapGQLResponse(pathFromData, clazz, (Function1<? super JavaType, ? extends GraphQLResponseDTO<? extends JsonNode, GraphQLErrorDTO>>)((Function1)arg_0 -> GitLabGQLDataDeSerializer.readAndMapGQLResponse$lambda$0(bodyReader, arg_0)));
    }

    private final <T> GraphQLResponseDTO<T, GraphQLErrorDTO> readAndMapGQLResponse(String[] pathFromData, Class<T> clazz, Function1<? super JavaType, ? extends GraphQLResponseDTO<? extends JsonNode, GraphQLErrorDTO>> responseSupplier) {
        Class[] classArray = new Class[]{JsonNode.class, GraphQLErrorDTO.class};
        JavaType responseType = mapper.getTypeFactory().constructParametricType(GraphQLResponseDTO.class, classArray);
        Intrinsics.checkNotNull((Object)responseType);
        GraphQLResponseDTO gqlResponse = (GraphQLResponseDTO)responseSupplier.invoke((Object)responseType);
        return this.mapGQLResponse((GraphQLResponseDTO<? extends JsonNode, GraphQLErrorDTO>)gqlResponse, pathFromData, clazz);
    }

    private final <T> GraphQLResponseDTO<T, GraphQLErrorDTO> mapGQLResponse(GraphQLResponseDTO<? extends JsonNode, GraphQLErrorDTO> result2, String[] pathFromData, Class<T> clazz) {
        JsonNode data = (JsonNode)result2.getData();
        if (data != null && !data.isNull()) {
            JsonNode node = data;
            for (String path : pathFromData) {
                if (node.get(path) == null) break;
            }
            if (!node.isNull()) {
                Object value = mapper.readValue(node.toString(), clazz);
                return new GraphQLResponseDTO(value, result2.getErrors());
            }
        }
        return new GraphQLResponseDTO(null, result2.getErrors());
    }

    private static final GraphQLResponseDTO readAndMapGQLResponse$lambda$0(Reader $bodyReader, JavaType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = mapper.readValue($bodyReader, it);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
        return (GraphQLResponseDTO)object;
    }

    static {
        ObjectMapper objectMapper = GitLabRestJsonDataDeSerializer.INSTANCE.genericConfig$intellij_vcs_gitlab(GitLabRestJsonDataDeSerializer.INSTANCE.gitlabJacksonMapper$intellij_vcs_gitlab()).setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX")).setPropertyNamingStrategy(PropertyNamingStrategies.LOWER_CAMEL_CASE);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"setPropertyNamingStrategy(...)");
        mapper = objectMapper;
    }
}

