/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.CommitListPanel;
import com.intellij.dvcs.ui.CompareBranchesHelper;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.dvcs.ui.RepositoryComboboxListCellRenderer;
import com.intellij.dvcs.util.CommitCompareInfo;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.SimpleAsyncChangesBrowser;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsFullCommitDetails;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

class CompareBranchesLogPanel
extends JPanel {
    private final CompareBranchesHelper myHelper;
    @NlsSafe
    private final String myBranchName;
    @NlsSafe
    private final String myCurrentBranchName;
    private final CommitCompareInfo myCompareInfo;
    private final Repository myInitialRepo;
    private CommitListPanel myHeadToBranchListPanel;
    private CommitListPanel myBranchToHeadListPanel;

    CompareBranchesLogPanel(@NotNull CompareBranchesHelper helper, @NotNull String branchName, @NotNull String currentBranchName, @NotNull CommitCompareInfo compareInfo, @NotNull Repository initialRepo) {
        if (helper == null) {
            CompareBranchesLogPanel.$$$reportNull$$$0(0);
        }
        if (branchName == null) {
            CompareBranchesLogPanel.$$$reportNull$$$0(1);
        }
        if (currentBranchName == null) {
            CompareBranchesLogPanel.$$$reportNull$$$0(2);
        }
        if (compareInfo == null) {
            CompareBranchesLogPanel.$$$reportNull$$$0(3);
        }
        if (initialRepo == null) {
            CompareBranchesLogPanel.$$$reportNull$$$0(4);
        }
        super(new BorderLayout(10, 4));
        this.myHelper = helper;
        this.myBranchName = branchName;
        this.myCurrentBranchName = currentBranchName;
        this.myCompareInfo = compareInfo;
        this.myInitialRepo = initialRepo;
        this.add((Component)this.createNorthPanel(), "North");
        this.add(this.createCenterPanel());
    }

    private JComponent createCenterPanel() {
        SimpleAsyncChangesBrowser changesBrowser = new SimpleAsyncChangesBrowser(this.myHelper.getProject(), false, true);
        this.myHeadToBranchListPanel = new CommitListPanel(this.getHeadToBranchCommits(this.myInitialRepo), DvcsBundle.message((String)"label.branch.fully.merged.to.branch", (Object[])new Object[]{this.myBranchName, this.myCurrentBranchName}));
        this.myBranchToHeadListPanel = new CommitListPanel(this.getBranchToHeadCommits(this.myInitialRepo), DvcsBundle.message((String)"label.branch.fully.merged.to.branch", (Object[])new Object[]{this.myCurrentBranchName, this.myBranchName}));
        CompareBranchesLogPanel.addSelectionListener(this.myHeadToBranchListPanel, this.myBranchToHeadListPanel, changesBrowser);
        CompareBranchesLogPanel.addSelectionListener(this.myBranchToHeadListPanel, this.myHeadToBranchListPanel, changesBrowser);
        this.myHeadToBranchListPanel.registerDiffAction(changesBrowser.getDiffAction());
        this.myBranchToHeadListPanel.registerDiffAction(changesBrowser.getDiffAction());
        JPanel htb = this.layoutCommitListPanel(true);
        JPanel bth = this.layoutCommitListPanel(false);
        JPanel listPanel = switch (this.getInfoType()) {
            default -> throw new IncompatibleClassChangeError();
            case CommitCompareInfo.InfoType.HEAD_TO_BRANCH -> htb;
            case CommitCompareInfo.InfoType.BRANCH_TO_HEAD -> bth;
            case CommitCompareInfo.InfoType.BOTH -> {
                Splitter lists = new Splitter(true, 0.5f);
                lists.setFirstComponent((JComponent)htb);
                lists.setSecondComponent((JComponent)bth);
                yield lists;
            }
        };
        Splitter rootPanel = new Splitter(false, 0.7f);
        rootPanel.setSecondComponent((JComponent)changesBrowser);
        rootPanel.setFirstComponent((JComponent)listPanel);
        return rootPanel;
    }

    private JComponent createNorthPanel() {
        final ComboBox repoSelector = new ComboBox((Object[])this.myCompareInfo.getRepositories().toArray(new Repository[0]));
        repoSelector.setRenderer((ListCellRenderer)((Object)new RepositoryComboboxListCellRenderer()));
        repoSelector.setSelectedItem((Object)this.myInitialRepo);
        repoSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Repository selectedRepo = (Repository)repoSelector.getSelectedItem();
                CompareBranchesLogPanel.this.myHeadToBranchListPanel.setCommits(CompareBranchesLogPanel.this.getHeadToBranchCommits(selectedRepo));
                CompareBranchesLogPanel.this.myBranchToHeadListPanel.setCommits(CompareBranchesLogPanel.this.getBranchToHeadCommits(selectedRepo));
            }
        });
        JPanel repoSelectorPanel = new JPanel(new FlowLayout(0, 0, 0));
        JBLabel label = new JBLabel(DvcsBundle.message((String)"label.repository", (Object[])new Object[0]) + " ");
        label.setLabelFor((Component)repoSelectorPanel);
        label.setDisplayedMnemonic(82);
        repoSelectorPanel.add((Component)label);
        repoSelectorPanel.add((Component)repoSelector);
        if (this.myCompareInfo.getRepositories().size() < 2) {
            repoSelectorPanel.setVisible(false);
        }
        return repoSelectorPanel;
    }

    private List<VcsFullCommitDetails> getBranchToHeadCommits(Repository selectedRepo) {
        return this.myCompareInfo.getBranchToHeadCommits(selectedRepo);
    }

    private List<VcsFullCommitDetails> getHeadToBranchCommits(Repository selectedRepo) {
        return this.myCompareInfo.getHeadToBranchCommits(selectedRepo);
    }

    private CommitCompareInfo.InfoType getInfoType() {
        return this.myCompareInfo.getInfoType();
    }

    private static void addSelectionListener(@NotNull CommitListPanel sourcePanel, @NotNull CommitListPanel otherPanel, @NotNull SimpleAsyncChangesBrowser changesBrowser) {
        if (sourcePanel == null) {
            CompareBranchesLogPanel.$$$reportNull$$$0(5);
        }
        if (otherPanel == null) {
            CompareBranchesLogPanel.$$$reportNull$$$0(6);
        }
        if (changesBrowser == null) {
            CompareBranchesLogPanel.$$$reportNull$$$0(7);
        }
        sourcePanel.addListMultipleSelectionListener((Consumer<? super List<Change>>)((Consumer)changes -> {
            changesBrowser.setChangesToDisplay((Collection)changes);
            otherPanel.clearSelection();
        }));
    }

    private JPanel layoutCommitListPanel(boolean forward) {
        String desc = this.makeDescription(forward);
        JPanel bth = new JPanel(new BorderLayout());
        JBLabel descriptionLabel = new JBLabel(desc, UIUtil.ComponentStyle.SMALL);
        descriptionLabel.setBorder((Border)JBUI.Borders.emptyBottom((int)5));
        bth.add((Component)descriptionLabel, "North");
        bth.add(forward ? this.myHeadToBranchListPanel : this.myBranchToHeadListPanel);
        return bth;
    }

    @NlsContexts.Label
    private String makeDescription(boolean forward) {
        String firstBranch = forward ? this.myCurrentBranchName : this.myBranchName;
        String secondBranch = forward ? this.myBranchName : this.myCurrentBranchName;
        return new HtmlBuilder().appendRaw(DvcsBundle.message((String)"compare.branches.commits.that.exist.in.branch.but.not.in.branch.vcs.command", (Object[])new Object[]{HtmlChunk.text((String)secondBranch).bold().code(), HtmlChunk.text((String)firstBranch).bold().code(), HtmlChunk.text((String)this.myHelper.formatLogCommand(firstBranch, secondBranch)).bold().code()})).wrapWithHtmlBody().toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentBranchName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compareInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialRepo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePanel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherPanel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changesBrowser";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dvcs/ui/CompareBranchesLogPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addSelectionListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

