/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInspection;

import com.intellij.codeInspection.AnalysisUastUtilKt;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemHolderUtilKt;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.execution.JUnitBundle;
import com.intellij.psi.PsiClass;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnchorOwner;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/execution/junit/codeInspection/RunWithVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "visitClass", "", "node", "Lorg/jetbrains/uast/UClass;", "intellij.junit"})
@SourceDebugExtension(value={"SMAP\nTestCaseWithMultipleRunnersInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestCaseWithMultipleRunnersInspection.kt\ncom/intellij/execution/junit/codeInspection/RunWithVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,42:1\n1#2:43\n*E\n"})
final class RunWithVisitor
extends AbstractUastNonRecursiveVisitor {
    @NotNull
    private final ProblemsHolder holder;

    public RunWithVisitor(@NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }

    public boolean visitClass(@NotNull UClass node) {
        ArrayDeque arrayDeque;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String[] stringArray = new String[]{"org.junit.runner.RunWith"};
        List runWiths = AnalysisUastUtilKt.findAnnotations((UAnnotated)((UAnnotated)node), (String[])stringArray);
        if (runWiths.isEmpty()) {
            return true;
        }
        ArrayDeque $this$visitClass_u24lambda_u240 = arrayDeque = new ArrayDeque();
        boolean bl = false;
        Collection collection = $this$visitClass_u24lambda_u240;
        PsiClass[] psiClassArray = node.getJavaPsi().getSupers();
        Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"getSupers(...)");
        CollectionsKt.addAll((Collection)collection, (Object[])psiClassArray);
        Queue queue = arrayDeque;
        while (!((Collection)queue).isEmpty()) {
            PsiClass parent = (PsiClass)queue.poll();
            if (parent.hasAnnotation("org.junit.runner.RunWith")) {
                Object[] objectArray = new Object[]{parent.getName()};
                String string = JUnitBundle.message("jvm.inspections.junit4.inherited.runwith.problem.descriptor", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String message = string;
                ProblemHolderUtilKt.registerUProblem((ProblemsHolder)this.holder, (UAnchorOwner)((UAnchorOwner)runWiths.get(0)), (String)message, (LocalQuickFix[])new LocalQuickFix[0], (ProblemHighlightType)ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                return true;
            }
            Collection collection2 = queue;
            PsiClass[] psiClassArray2 = parent.getSupers();
            Intrinsics.checkNotNullExpressionValue((Object)psiClassArray2, (String)"getSupers(...)");
            CollectionsKt.addAll((Collection)collection2, (Object[])psiClassArray2);
        }
        return true;
    }
}

