/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.model;

import com.intellij.execution.CantRunException;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiUtilCore;
import com.theoryinpractice.testng.TestngBundle;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.model.TestNGTestObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.testng.xml.Parser;

public class TestNGTestSuite
extends TestNGTestObject {
    private static final Object PARSE_LOCK = new Object();

    public TestNGTestSuite(TestNGConfiguration config) {
        super(config);
    }

    @Override
    public void fillTestObjects(Map<PsiClass, Map<PsiMethod, List<String>>> classes) throws CantRunException {
    }

    @Override
    public String getGeneratedName() {
        return this.myConfig.getPersistantData().getSuiteName();
    }

    @Override
    public String getActionName() {
        VirtualFile virtualFile;
        String suiteName = this.myConfig.getPersistantData().getSuiteName();
        if (!suiteName.isEmpty() && (virtualFile = LocalFileSystem.getInstance().findFileByPath(suiteName)) != null) {
            return ProjectUtilCore.displayUrlRelativeToProject((VirtualFile)virtualFile, (String)virtualFile.getPresentableUrl(), (Project)this.myConfig.getProject(), (boolean)true, (boolean)false);
        }
        return suiteName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        block6: {
            Document document;
            String suiteName = this.myConfig.getPersistantData().getSuiteName();
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(suiteName);
            Document document2 = document = virtualFile != null ? FileDocumentManager.getInstance().getDocument(virtualFile) : null;
            if (document == null) {
                throw new RuntimeConfigurationException(TestngBundle.message("dialog.message.file.not.found", suiteName));
            }
            try {
                Parser parser = new Parser((InputStream)new ByteArrayInputStream(document.getText().getBytes(StandardCharsets.UTF_8)));
                parser.setLoadClasses(false);
                Object object = PARSE_LOCK;
                synchronized (object) {
                    parser.parse();
                }
            }
            catch (Throwable e) {
                if (suiteName.endsWith(".yaml")) break block6;
                throw new RuntimeConfigurationException(TestngBundle.message("testng.dialog.message.unable.to.parse.specified.exception", suiteName));
            }
        }
    }

    @Override
    public boolean isConfiguredByElement(PsiElement element) {
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        return virtualFile != null && Comparing.strEqual((String)this.myConfig.getPersistantData().getSuiteName(), (String)virtualFile.getPath());
    }
}

