/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.core.git.renderers;

import com.intellij.settingsSync.core.git.table.FileRow;
import com.intellij.settingsSync.core.git.table.SeparatorRow;
import com.intellij.settingsSync.core.git.table.SettingsHistoryTable;
import com.intellij.settingsSync.core.git.table.SettingsHistoryTableRow;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0003\b \u0018\u0000 :2\u00020\u0001:\u0002:;B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H&J:\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0018H\u0004J\b\u0010\u001e\u001a\u00020\u000fH\u0002J \u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0018H\u0014J5\u0010%\u001a\u00020\u000f*\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u00052\u0017\u0010(\u001a\u0013\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u000f0)\u00a2\u0006\u0002\b*H\u0082\b\u00a2\u0006\u0002\u0010+J\b\u0010,\u001a\u00020\u000fH\u0016J\u0018\u0010-\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0004J\u0018\u0010.\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0004J\u0018\u0010/\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0004J(\u00100\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00101\u001a\u00020\u0015H\u0002J\u0018\u00102\u001a\u00020#2\u0006\u00103\u001a\u00020#2\u0006\u00104\u001a\u00020\u0018H\u0004J\u0010\u00105\u001a\u00020\u000f2\u0006\u00106\u001a\u00020\rH\u0004J\b\u00107\u001a\u00020\u000fH\u0004J\n\u00108\u001a\u0004\u0018\u000109H\u0005R\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\n\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/intellij/settingsSync/core/git/renderers/SettingsHistoryCellRenderer;", "Lcom/intellij/ui/ColoredTableCellRenderer;", "<init>", "()V", "iconOpacity", "", "getIconOpacity", "()Ljava/lang/Float;", "setIconOpacity", "(Ljava/lang/Float;)V", "Ljava/lang/Float;", "tooltipTextFragments", "", "Lcom/intellij/settingsSync/core/git/renderers/SettingsHistoryCellRenderer$TooltipTextFragment;", "customizeHistoryCellRenderer", "", "table", "Lcom/intellij/settingsSync/core/git/table/SettingsHistoryTable;", "row", "Lcom/intellij/settingsSync/core/git/table/SettingsHistoryTableRow;", "selected", "", "hasFocus", "rowIndex", "", "customizeCellRenderer", "Ljavax/swing/JTable;", "value", "", "column", "setCellBorders", "paintIcon", "g", "Ljava/awt/Graphics;", "icon", "Ljavax/swing/Icon;", "offset", "withAlphaComposite", "Ljava/awt/Graphics2D;", "alpha", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Ljava/awt/Graphics2D;Ljava/lang/Float;Lkotlin/jvm/functions/Function1;)V", "clear", "isExpanded", "isHovered", "isGreyedOut", "paintBackground", "focused", "createLabelIcon", "rawIcon", "size", "addTooltipTextFragment", "tooltipTextFragment", "addNewLineToTooltip", "buildTooltip", "", "Companion", "TooltipTextFragment", "intellij.settingsSync.core"})
@SourceDebugExtension(value={"SMAP\nSettingsHistoryCellRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsHistoryCellRenderer.kt\ncom/intellij/settingsSync/core/git/renderers/SettingsHistoryCellRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,174:1\n66#1,10:175\n1869#2,2:185\n*S KotlinDebug\n*F\n+ 1 SettingsHistoryCellRenderer.kt\ncom/intellij/settingsSync/core/git/renderers/SettingsHistoryCellRenderer\n*L\n60#1:175,10\n139#1:185,2\n*E\n"})
public abstract class SettingsHistoryCellRenderer
extends ColoredTableCellRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Float iconOpacity;
    @NotNull
    private final List<List<TooltipTextFragment>> tooltipTextFragments = new ArrayList();
    private static final boolean isOldUI = !ExperimentalUI.Companion.isNewUI();

    @Nullable
    protected final Float getIconOpacity() {
        return this.iconOpacity;
    }

    protected final void setIconOpacity(@Nullable Float f) {
        this.iconOpacity = f;
    }

    public abstract void customizeHistoryCellRenderer(@NotNull SettingsHistoryTable var1, @NotNull SettingsHistoryTableRow var2, boolean var3, boolean var4, int var5);

    protected final void customizeCellRenderer(@NotNull JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        SettingsHistoryTable cfr_ignored_0 = (SettingsHistoryTable)((Object)table);
        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.intellij.settingsSync.core.git.table.SettingsHistoryTableRow");
        SettingsHistoryTableRow cfr_ignored_1 = (SettingsHistoryTableRow)value;
        this.setCellBorders();
        this.paintBackground((SettingsHistoryTable)((Object)table), (SettingsHistoryTableRow)value, selected, ((SettingsHistoryTable)((Object)table)).isFocusOwner());
        this.customizeHistoryCellRenderer((SettingsHistoryTable)((Object)table), (SettingsHistoryTableRow)value, selected, ((SettingsHistoryTable)((Object)table)).isFocusOwner(), row);
    }

    private final void setCellBorders() {
        this.setPaintFocusBorder(false);
        this.setFocusBorderAroundIcon(true);
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
    }

    protected void paintIcon(@NotNull Graphics g, @NotNull Icon icon, int offset) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Graphics2D graphics2D = g instanceof Graphics2D ? (Graphics2D)g : null;
        if (graphics2D == null) {
            super.paintIcon(g, icon, offset);
            return;
        }
        Graphics2D g2 = graphics2D;
        SettingsHistoryCellRenderer settingsHistoryCellRenderer = this;
        Graphics2D graphics2D2 = g2;
        Float alpha$iv = this.iconOpacity;
        boolean $i$f$withAlphaComposite = false;
        if (alpha$iv == null) {
            void $this$paintIcon_u24lambda_u240 = $this$withAlphaComposite$iv;
            boolean bl = false;
            super.paintIcon((Graphics)$this$paintIcon_u24lambda_u240, icon, offset);
        } else {
            Composite originalComposite$iv = $this$withAlphaComposite$iv.getComposite();
            $this$withAlphaComposite$iv.setComposite(AlphaComposite.SrcOver.derive(alpha$iv.floatValue()));
            void $this$paintIcon_u24lambda_u240 = $this$withAlphaComposite$iv;
            boolean bl = false;
            super.paintIcon((Graphics)$this$paintIcon_u24lambda_u240, icon, offset);
            $this$withAlphaComposite$iv.setComposite(originalComposite$iv);
        }
    }

    private final void withAlphaComposite(Graphics2D $this$withAlphaComposite, Float alpha, Function1<? super Graphics2D, Unit> block) {
        boolean $i$f$withAlphaComposite = false;
        if (alpha == null) {
            block.invoke((Object)$this$withAlphaComposite);
        } else {
            Composite originalComposite = $this$withAlphaComposite.getComposite();
            $this$withAlphaComposite.setComposite(AlphaComposite.SrcOver.derive(alpha.floatValue()));
            block.invoke((Object)$this$withAlphaComposite);
            $this$withAlphaComposite.setComposite(originalComposite);
        }
    }

    public void clear() {
        this.tooltipTextFragments.clear();
        this.setToolTipText(null);
        this.iconOpacity = null;
        super.clear();
    }

    protected final boolean isExpanded(@NotNull SettingsHistoryTable table, @NotNull SettingsHistoryTableRow row) {
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        return table.getModel().getExpandedRows().contains(row.getRecord().getId());
    }

    protected final boolean isHovered(@NotNull SettingsHistoryTable table, @NotNull SettingsHistoryTableRow row) {
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        return table.isFocusOwner() && Intrinsics.areEqual((Object)row.getRecord(), (Object)table.getHoveredRecord());
    }

    protected final boolean isGreyedOut(@NotNull SettingsHistoryTable table, int rowIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        return table.isFocusOwner() && table.isResetHovered() && rowIndex < table.getHoveredRow();
    }

    private final void paintBackground(SettingsHistoryTable table, SettingsHistoryTableRow row, boolean selected, boolean focused) {
        if (row instanceof SeparatorRow) {
            this.setBackground(JBUI.CurrentTheme.Table.BACKGROUND);
            return;
        }
        boolean hovered = this.isHovered(table, row);
        if (selected) {
            if (row instanceof FileRow) {
                this.setBackground(JBUI.CurrentTheme.Table.Selection.background((boolean)focused));
            } else {
                this.setBackground(JBUI.CurrentTheme.Table.Hover.background((boolean)focused));
            }
        } else if (hovered) {
            this.setBackground(JBUI.CurrentTheme.Table.Hover.background((boolean)focused));
        } else {
            this.setBackground(JBUI.CurrentTheme.Table.BACKGROUND);
        }
    }

    @NotNull
    protected final Icon createLabelIcon(@NotNull Icon rawIcon, int size) {
        Intrinsics.checkNotNullParameter((Object)rawIcon, (String)"rawIcon");
        return IconUtil.toSize((Icon)rawIcon, (int)JBUI.scale((int)size), (int)JBUI.scale((int)size));
    }

    protected final void addTooltipTextFragment(@NotNull TooltipTextFragment tooltipTextFragment) {
        Intrinsics.checkNotNullParameter((Object)tooltipTextFragment, (String)"tooltipTextFragment");
        if (this.tooltipTextFragments.isEmpty()) {
            this.addNewLineToTooltip();
        }
        List currentLine = (List)CollectionsKt.last(this.tooltipTextFragments);
        currentLine.add(tooltipTextFragment);
    }

    protected final void addNewLineToTooltip() {
        this.tooltipTextFragments.add(new ArrayList());
    }

    @Nls
    @Nullable
    protected final String buildTooltip() {
        if (this.tooltipTextFragments.isEmpty()) {
            return null;
        }
        StringBuilder result2 = new StringBuilder("<html><body>");
        for (List<TooltipTextFragment> line : this.tooltipTextFragments) {
            result2.append("<div>");
            Iterable $this$forEach$iv = line;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TooltipTextFragment it = (TooltipTextFragment)element$iv;
                boolean bl = false;
                result2.append(it.buildSpanTag());
            }
            result2.append("</div>");
        }
        result2.append("</body></html>");
        return result2.toString();
    }

    protected static final boolean isOldUI() {
        return Companion.isOldUI();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u00020\u00058\u0004X\u0085\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0004\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/settingsSync/core/git/renderers/SettingsHistoryCellRenderer$Companion;", "", "<init>", "()V", "isOldUI", "", "isOldUI$annotations", "()Z", "intellij.settingsSync.core"})
    public static final class Companion {
        private Companion() {
        }

        protected final boolean isOldUI() {
            return isOldUI;
        }

        @JvmStatic
        protected static /* synthetic */ void isOldUI$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\b\u0084\b\u0018\u00002\u00020\u0001B!\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\f\u001a\u00020\u0003J\b\u0010\r\u001a\u00020\u0003H\u0002J\f\u0010\u000e\u001a\u00020\u0003*\u00020\u000fH\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/settingsSync/core/git/renderers/SettingsHistoryCellRenderer$TooltipTextFragment;", "", "text", "", "isGray", "", "isSmall", "<init>", "(Ljava/lang/String;ZZ)V", "getText", "()Ljava/lang/String;", "()Z", "buildSpanTag", "buildStyleContent", "toHexString", "Ljava/awt/Color;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "intellij.settingsSync.core"})
    protected static final class TooltipTextFragment {
        @NotNull
        private final String text;
        private final boolean isGray;
        private final boolean isSmall;

        public TooltipTextFragment(@Nls @NotNull String text, boolean isGray, boolean isSmall) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.text = text;
            this.isGray = isGray;
            this.isSmall = isSmall;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public final boolean isGray() {
            return this.isGray;
        }

        public final boolean isSmall() {
            return this.isSmall;
        }

        @NotNull
        public final String buildSpanTag() {
            return StringsKt.trimIndent((String)("\n        <span style=\"" + this.buildStyleContent() + "\">" + this.text + "</span>\n      "));
        }

        private final String buildStyleContent() {
            StringBuilder result2 = new StringBuilder();
            if (this.isGray) {
                Color color = SimpleTextAttributes.GRAY_ATTRIBUTES.getFgColor();
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getFgColor(...)");
                String grayColor = this.toHexString(color);
                result2.append("color:").append(grayColor).append(";");
            }
            if (this.isSmall) {
                result2.append("font-size:").append(UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL)).append(";");
            }
            String string = result2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @NonNls
        private final String toHexString(Color $this$toHexString) {
            String red = Integer.toHexString($this$toHexString.getRed());
            String green = Integer.toHexString($this$toHexString.getGreen());
            String blue = Integer.toHexString($this$toHexString.getBlue());
            Intrinsics.checkNotNull((Object)red);
            String string = StringsKt.padStart((String)red, (int)2, (char)'0');
            Intrinsics.checkNotNull((Object)green);
            String string2 = StringsKt.padStart((String)green, (int)2, (char)'0');
            Intrinsics.checkNotNull((Object)blue);
            return "#" + string + string2 + StringsKt.padStart((String)blue, (int)2, (char)'0');
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        public final boolean component2() {
            return this.isGray;
        }

        public final boolean component3() {
            return this.isSmall;
        }

        @NotNull
        public final TooltipTextFragment copy(@Nls @NotNull String text, boolean isGray, boolean isSmall) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return new TooltipTextFragment(text, isGray, isSmall);
        }

        public static /* synthetic */ TooltipTextFragment copy$default(TooltipTextFragment tooltipTextFragment, String string, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                string = tooltipTextFragment.text;
            }
            if ((n & 2) != 0) {
                bl = tooltipTextFragment.isGray;
            }
            if ((n & 4) != 0) {
                bl2 = tooltipTextFragment.isSmall;
            }
            return tooltipTextFragment.copy(string, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "TooltipTextFragment(text=" + this.text + ", isGray=" + this.isGray + ", isSmall=" + this.isSmall + ")";
        }

        public int hashCode() {
            int result2 = this.text.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isGray);
            result2 = result2 * 31 + Boolean.hashCode(this.isSmall);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TooltipTextFragment)) {
                return false;
            }
            TooltipTextFragment tooltipTextFragment = (TooltipTextFragment)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)tooltipTextFragment.text)) {
                return false;
            }
            if (this.isGray != tooltipTextFragment.isGray) {
                return false;
            }
            return this.isSmall == tooltipTextFragment.isSmall;
        }
    }
}

