/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.Date;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.jcajce.spec.EdDSAParameterSpec;
import org.bouncycastle.jcajce.spec.XDHParameterSpec;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.operator.PGPKeyPairGenerator;
import org.bouncycastle.openpgp.operator.PGPKeyPairGeneratorProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyPair;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;

public class JcaPGPKeyPairGeneratorProvider
extends PGPKeyPairGeneratorProvider {
    private OperatorHelper helper;
    private SecureRandom secureRandom = CryptoServicesRegistrar.getSecureRandom();

    public JcaPGPKeyPairGeneratorProvider() {
        this.helper = new OperatorHelper(new DefaultJcaJceHelper());
    }

    public JcaPGPKeyPairGeneratorProvider setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcaPGPKeyPairGeneratorProvider setProvider(String string) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(string));
        return this;
    }

    public JcaPGPKeyPairGeneratorProvider setSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
        return this;
    }

    @Override
    public PGPKeyPairGenerator get(int n, Date date) {
        return new JcaPGPKeyPairGenerator(n, date, this.helper, this.secureRandom);
    }

    private static class JcaPGPKeyPairGenerator
    extends PGPKeyPairGenerator {
        private final OperatorHelper helper;

        public JcaPGPKeyPairGenerator(int n, Date date, OperatorHelper operatorHelper, SecureRandom secureRandom) {
            super(n, date, secureRandom, new JcaKeyFingerprintCalculator());
            this.helper = operatorHelper;
        }

        @Override
        public PGPKeyPair generateRsaKeyPair(BigInteger bigInteger, int n) throws PGPException {
            try {
                KeyPairGenerator keyPairGenerator = this.helper.createKeyPairGenerator("RSA");
                keyPairGenerator.initialize(new RSAKeyGenParameterSpec(n, bigInteger));
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                return new JcaPGPKeyPair(this.version, 1, keyPair, this.creationTime);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new PGPException("Cannot generate RSA key pair", generalSecurityException);
            }
        }

        @Override
        public PGPKeyPair generateEd25519KeyPair() throws PGPException {
            try {
                KeyPairGenerator keyPairGenerator = this.helper.createKeyPairGenerator("EDDSA");
                keyPairGenerator.initialize(new EdDSAParameterSpec("Ed25519"));
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                return new JcaPGPKeyPair(this.version, 27, keyPair, this.creationTime);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new PGPException("Cannot generate Ed25519 key pair", generalSecurityException);
            }
        }

        @Override
        public PGPKeyPair generateEd448KeyPair() throws PGPException {
            try {
                KeyPairGenerator keyPairGenerator = this.helper.createKeyPairGenerator("EDDSA");
                keyPairGenerator.initialize(new EdDSAParameterSpec("Ed448"));
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                return new JcaPGPKeyPair(this.version, 28, keyPair, this.creationTime);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new PGPException("Cannot generate Ed448 key pair", generalSecurityException);
            }
        }

        @Override
        public PGPKeyPair generateX25519KeyPair() throws PGPException {
            try {
                KeyPairGenerator keyPairGenerator = this.helper.createKeyPairGenerator("XDH");
                keyPairGenerator.initialize(new XDHParameterSpec("X25519"));
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                return new JcaPGPKeyPair(this.version, 25, keyPair, this.creationTime);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new PGPException("Cannot generate X25519 key pair", generalSecurityException);
            }
        }

        @Override
        public PGPKeyPair generateX448KeyPair() throws PGPException {
            try {
                KeyPairGenerator keyPairGenerator = this.helper.createKeyPairGenerator("XDH");
                keyPairGenerator.initialize(new XDHParameterSpec("X448"));
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                return new JcaPGPKeyPair(this.version, 26, keyPair, this.creationTime);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new PGPException("Cannot generate X448 key pair", generalSecurityException);
            }
        }

        @Override
        public PGPKeyPair generateLegacyEd25519KeyPair() throws PGPException {
            if (this.version == 6) {
                throw new PGPException("An implementation MUST NOT generate a v6 LegacyEd25519 key pair.");
            }
            try {
                KeyPairGenerator keyPairGenerator = this.helper.createKeyPairGenerator("EDDSA");
                keyPairGenerator.initialize(new EdDSAParameterSpec("Ed25519"));
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                return new JcaPGPKeyPair(this.version, 22, keyPair, this.creationTime);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new PGPException("Cannot generate LegacyEd25519 key pair.");
            }
        }

        @Override
        public PGPKeyPair generateLegacyX25519KeyPair() throws PGPException {
            if (this.version == 6) {
                throw new PGPException("An implementation MUST NOT generate a v6 LegacyX25519 key pair.");
            }
            try {
                KeyPairGenerator keyPairGenerator = this.helper.createKeyPairGenerator("XDH");
                keyPairGenerator.initialize(new XDHParameterSpec("X25519"));
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                return new JcaPGPKeyPair(this.version, 18, keyPair, this.creationTime);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new PGPException("Cannot generate LegacyX25519 key pair.", generalSecurityException);
            }
        }
    }
}

