/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.type.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.ConstructorCallHighlighter;
import org.jetbrains.plugins.groovy.highlighting.HighlightSink;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyCallReference;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyConstructorReference;
import org.jetbrains.plugins.groovy.lang.typing.GrCollectionConstructorConverter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\rH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/type/highlighting/LiteralConstructorReferenceHighlighter;", "Lorg/jetbrains/plugins/groovy/codeInspection/type/highlighting/ConstructorCallHighlighter;", "reference", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyConstructorReference;", "highlightElement", "Lcom/intellij/psi/PsiElement;", "sink", "Lorg/jetbrains/plugins/groovy/highlighting/HighlightSink;", "<init>", "(Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyConstructorReference;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/plugins/groovy/highlighting/HighlightSink;)V", "getHighlightElement", "()Lcom/intellij/psi/PsiElement;", "shouldHighlightInapplicable", "", "highlightMethodApplicability", "intellij.groovy.psi"})
public final class LiteralConstructorReferenceHighlighter
extends ConstructorCallHighlighter {
    @NotNull
    private final PsiElement highlightElement;

    public LiteralConstructorReferenceHighlighter(@NotNull GroovyConstructorReference reference, @NotNull PsiElement highlightElement, @NotNull HighlightSink sink) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)highlightElement, (String)"highlightElement");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        super(reference, sink);
        this.highlightElement = highlightElement;
    }

    @Override
    @NotNull
    protected PsiElement getHighlightElement() {
        return this.highlightElement;
    }

    @Override
    protected boolean shouldHighlightInapplicable() {
        GroovyCallReference groovyCallReference = this.getReference();
        Intrinsics.checkNotNull((Object)groovyCallReference, (String)"null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.resolve.api.GroovyConstructorReference");
        GroovyResolveResult groovyResolveResult = ((GroovyConstructorReference)groovyCallReference).resolveClass();
        PsiElement psiElement = groovyResolveResult != null ? groovyResolveResult.getElement() : null;
        PsiClass clazz = psiElement instanceof PsiClass ? (PsiClass)psiElement : null;
        return clazz == null || !GrCollectionConstructorConverter.Companion.hasCollectionApplicableConstructor(clazz, this.getHighlightElement());
    }

    @Override
    public boolean highlightMethodApplicability() {
        Collection<? extends GroovyResolveResult> collection = this.getReference().resolve(false);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"resolve(...)");
        Collection<? extends GroovyResolveResult> results = collection;
        if (results.isEmpty()) {
            PsiClass clazz;
            GroovyCallReference groovyCallReference = this.getReference();
            Intrinsics.checkNotNull((Object)groovyCallReference, (String)"null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.resolve.api.GroovyConstructorReference");
            GroovyResolveResult groovyResolveResult = ((GroovyConstructorReference)groovyCallReference).resolveClass();
            Object[] objectArray = groovyResolveResult != null ? groovyResolveResult.getElement() : null;
            PsiClass psiClass = clazz = objectArray instanceof PsiClass ? (PsiClass)objectArray : null;
            if (clazz == null) {
                return false;
            }
            objectArray = new Object[]{clazz.getName()};
            this.getSink().registerError(this.getHighlightElement(), GroovyBundle.message("cannot.instantiate.interface", objectArray), new LocalQuickFix[0]);
            return true;
        }
        return super.highlightMethodApplicability();
    }
}

