/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GrInspectionUtil;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ComparisonUtils;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ParenthesesUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;

public final class GroovyPointlessBooleanInspection
extends BaseInspection {
    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new PointlessBooleanExpressionVisitor();
    }

    @Override
    public String buildErrorString(Object ... args) {
        return GroovyBundle.message("pointless.boolean.problem.descriptor", new Object[0]);
    }

    @Nullable
    private static String calculateSimplifiedBinaryExpression(GrBinaryExpression expression) {
        IElementType sign = expression.getOperationTokenType();
        GrExpression lhs = expression.getLeftOperand();
        GrExpression rhs = expression.getRightOperand();
        if (rhs == null) {
            return null;
        }
        String rhsText = rhs.getText();
        String lhsText = lhs.getText();
        if (sign.equals(GroovyElementTypes.T_LAND)) {
            if (GroovyPointlessBooleanInspection.isTrue(lhs)) {
                return rhsText;
            }
            return lhsText;
        }
        if (sign.equals(GroovyElementTypes.T_LOR)) {
            if (GroovyPointlessBooleanInspection.isFalse(lhs)) {
                return rhsText;
            }
            return lhsText;
        }
        if (sign.equals(GroovyElementTypes.T_XOR) || sign.equals(GroovyElementTypes.T_NEQ)) {
            if (GroovyPointlessBooleanInspection.isFalse(lhs)) {
                return rhsText;
            }
            if (GroovyPointlessBooleanInspection.isFalse(rhs)) {
                return lhsText;
            }
            if (GroovyPointlessBooleanInspection.isTrue(lhs)) {
                return GroovyPointlessBooleanInspection.createStringForNegatedExpression(rhs);
            }
            return GroovyPointlessBooleanInspection.createStringForNegatedExpression(lhs);
        }
        if (sign.equals(GroovyElementTypes.T_EQ)) {
            if (GroovyPointlessBooleanInspection.isTrue(lhs)) {
                return rhsText;
            }
            if (GroovyPointlessBooleanInspection.isTrue(rhs)) {
                return lhsText;
            }
            if (GroovyPointlessBooleanInspection.isFalse(lhs)) {
                return GroovyPointlessBooleanInspection.createStringForNegatedExpression(rhs);
            }
            return GroovyPointlessBooleanInspection.createStringForNegatedExpression(lhs);
        }
        return "";
    }

    private static String createStringForNegatedExpression(GrExpression exp) {
        if (ComparisonUtils.isComparison(exp)) {
            GrBinaryExpression binaryExpression = (GrBinaryExpression)exp;
            IElementType sign = binaryExpression.getOperationTokenType();
            String negatedComparison = ComparisonUtils.getNegatedComparison(sign);
            GrExpression lhs = binaryExpression.getLeftOperand();
            GrExpression rhs = binaryExpression.getRightOperand();
            if (rhs == null) {
                return lhs.getText() + negatedComparison;
            }
            return lhs.getText() + negatedComparison + rhs.getText();
        }
        String baseText = exp.getText();
        if (ParenthesesUtils.getPrecedence(exp) > ParenthesesUtils.PREFIX_PRECEDENCE) {
            return "!(" + baseText + ")";
        }
        return "!" + baseText;
    }

    @NonNls
    private static String calculateSimplifiedPrefixExpression(GrUnaryExpression expression) {
        GrExpression operand = expression.getOperand();
        if (GroovyPointlessBooleanInspection.isUnaryNot(operand)) {
            return GroovyPointlessBooleanInspection.booleanLiteral(((GrUnaryExpression)operand).getOperand());
        }
        return GroovyPointlessBooleanInspection.negateBooleanLiteral(operand);
    }

    @NotNull
    private static String negateBooleanLiteral(GrExpression operand) {
        if (GroovyPointlessBooleanInspection.isTrue(operand)) {
            return "false";
        }
        if (GroovyPointlessBooleanInspection.isFalse(operand)) {
            return "true";
        }
        throw new IllegalStateException(operand.getText());
    }

    @NotNull
    private static String booleanLiteral(GrExpression operand) {
        if (GroovyPointlessBooleanInspection.isTrue(operand)) {
            return "true";
        }
        if (GroovyPointlessBooleanInspection.isFalse(operand)) {
            return "false";
        }
        throw new IllegalStateException(operand.getText());
    }

    @Override
    public LocalQuickFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            GroovyPointlessBooleanInspection.$$$reportNull$$$0(0);
        }
        return new BooleanLiteralComparisonFix();
    }

    private static boolean isPointless(IElementType sign, GrExpression rhs, GrExpression lhs) {
        if (sign.equals(GroovyElementTypes.T_EQ) || sign.equals(GroovyElementTypes.T_NEQ)) {
            return GroovyPointlessBooleanInspection.equalityExpressionIsPointless(lhs, rhs);
        }
        if (sign.equals(GroovyElementTypes.T_LAND)) {
            return GroovyPointlessBooleanInspection.andExpressionIsPointless(lhs, rhs);
        }
        if (sign.equals(GroovyElementTypes.T_LOR)) {
            return GroovyPointlessBooleanInspection.orExpressionIsPointless(lhs, rhs);
        }
        if (sign.equals(GroovyElementTypes.T_XOR)) {
            return GroovyPointlessBooleanInspection.xorExpressionIsPointless(lhs, rhs);
        }
        return false;
    }

    private static boolean equalityExpressionIsPointless(GrExpression lhs, GrExpression rhs) {
        return (GroovyPointlessBooleanInspection.isTrue(lhs) || GroovyPointlessBooleanInspection.isFalse(lhs)) && GroovyPointlessBooleanInspection.isBoolean(rhs) || (GroovyPointlessBooleanInspection.isTrue(rhs) || GroovyPointlessBooleanInspection.isFalse(rhs)) && GroovyPointlessBooleanInspection.isBoolean(lhs);
    }

    private static boolean isBoolean(GrExpression expression) {
        PsiType type = expression.getType();
        return PsiTypes.booleanType().equals((Object)type);
    }

    private static boolean andExpressionIsPointless(GrExpression lhs, GrExpression rhs) {
        return GroovyPointlessBooleanInspection.isTrue(lhs) || GroovyPointlessBooleanInspection.isTrue(rhs);
    }

    private static boolean orExpressionIsPointless(GrExpression lhs, GrExpression rhs) {
        return GroovyPointlessBooleanInspection.isFalse(lhs) || GroovyPointlessBooleanInspection.isFalse(rhs);
    }

    private static boolean xorExpressionIsPointless(GrExpression lhs, GrExpression rhs) {
        return GroovyPointlessBooleanInspection.isTrue(lhs) || GroovyPointlessBooleanInspection.isTrue(rhs) || GroovyPointlessBooleanInspection.isFalse(lhs) || GroovyPointlessBooleanInspection.isFalse(rhs);
    }

    private static boolean isUnaryNot(GrExpression arg) {
        return arg instanceof GrUnaryExpression && ((GrUnaryExpression)arg).getOperationTokenType() == GroovyElementTypes.T_NOT;
    }

    private static boolean isBooleanLiteral(GrExpression arg) {
        return GroovyPointlessBooleanInspection.isFalse(arg) || GroovyPointlessBooleanInspection.isTrue(arg);
    }

    private static boolean isTrue(GrExpression expression) {
        if (expression == null) {
            return false;
        }
        if (!(expression instanceof GrLiteral)) {
            return false;
        }
        @NonNls String text = expression.getText();
        return "true".equals(text);
    }

    private static boolean isFalse(GrExpression expression) {
        if (expression == null) {
            return false;
        }
        if (!(expression instanceof GrLiteral)) {
            return false;
        }
        @NonNls String text = expression.getText();
        return "false".equals(text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyPointlessBooleanInspection", "buildFix"));
    }

    private static class PointlessBooleanExpressionVisitor
    extends BaseInspectionVisitor {
        private static final TokenSet booleanTokens = TokenSet.create((IElementType[])new IElementType[]{GroovyElementTypes.T_LAND, GroovyElementTypes.T_LOR, GroovyElementTypes.T_XOR, GroovyElementTypes.T_EQ, GroovyElementTypes.T_NEQ});

        private PointlessBooleanExpressionVisitor() {
        }

        @Override
        public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
            if (expression == null) {
                PointlessBooleanExpressionVisitor.$$$reportNull$$$0(0);
            }
            if (PsiUtilKt.isFake(expression)) {
                return;
            }
            IElementType sign = expression.getOperationTokenType();
            if (!booleanTokens.contains(sign)) {
                return;
            }
            GrExpression rhs = expression.getRightOperand();
            if (rhs == null) {
                return;
            }
            GrExpression lhs = expression.getLeftOperand();
            if (GroovyPointlessBooleanInspection.isPointless(sign, rhs, lhs)) {
                this.registerError(expression);
            }
        }

        @Override
        public void visitUnaryExpression(@NotNull GrUnaryExpression expression) {
            IElementType sign;
            if (expression == null) {
                PointlessBooleanExpressionVisitor.$$$reportNull$$$0(1);
            }
            if (!(sign = expression.getOperationTokenType()).equals(GroovyElementTypes.T_NOT)) {
                return;
            }
            GrExpression operand = expression.getOperand();
            if (GroovyPointlessBooleanInspection.isBooleanLiteral(operand)) {
                PsiElement parent = expression.getParent();
                if (parent instanceof GrExpression && GroovyPointlessBooleanInspection.isUnaryNot((GrExpression)parent)) {
                    return;
                }
                this.registerError(expression);
            } else if (GroovyPointlessBooleanInspection.isUnaryNot(operand) && GroovyPointlessBooleanInspection.isBooleanLiteral(((GrUnaryExpression)operand).getOperand())) {
                this.registerError(expression);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyPointlessBooleanInspection$PointlessBooleanExpressionVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBinaryExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitUnaryExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class BooleanLiteralComparisonFix
    extends PsiUpdateModCommandQuickFix {
        private BooleanLiteralComparisonFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = GroovyBundle.message("pointless.boolean.quickfix", new Object[0]);
            if (string == null) {
                BooleanLiteralComparisonFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                BooleanLiteralComparisonFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                BooleanLiteralComparisonFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                BooleanLiteralComparisonFix.$$$reportNull$$$0(3);
            }
            if (element instanceof GrBinaryExpression) {
                GrBinaryExpression expression = (GrBinaryExpression)element;
                String replacementString = GroovyPointlessBooleanInspection.calculateSimplifiedBinaryExpression(expression);
                GrInspectionUtil.replaceExpression(expression, replacementString);
            } else {
                GrUnaryExpression expression = (GrUnaryExpression)element;
                String replacementString = GroovyPointlessBooleanInspection.calculateSimplifiedPrefixExpression(expression);
                GrInspectionUtil.replaceExpression(expression, replacementString);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyPointlessBooleanInspection$BooleanLiteralComparisonFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyPointlessBooleanInspection$BooleanLiteralComparisonFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

