/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.html;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.flavours.gfm.TableAwareCodeSpanGeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.plugins.markdown.extensions.jcef.commandRunner.CommandRunnerExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u000fR\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/html/CodeSpanRunnerGeneratingProvider;", "Lorg/intellij/markdown/flavours/gfm/TableAwareCodeSpanGeneratingProvider;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "processNode", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "intellij.markdown"})
public final class CodeSpanRunnerGeneratingProvider
extends TableAwareCodeSpanGeneratingProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile file;

    public CodeSpanRunnerGeneratingProvider(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.project = project;
        this.file = file;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor2, @NotNull String text2, @NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        CommandRunnerExtension codeViewExtension = CommandRunnerExtension.Companion.getRunnerByFile(this.file);
        if (codeViewExtension == null) {
            super.processNode(visitor2, text2, node);
            return;
        }
        boolean isInsideTable = this.isInsideTable(node);
        List nodes = this.collectContentNodes(node);
        String content = ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)nodes, (CharSequence)"", null, null, (int)0, null, arg_0 -> CodeSpanRunnerGeneratingProvider.processNode$lambda$0(this, text2, isInsideTable, arg_0), (int)30, null))).toString();
        String lineRunner = codeViewExtension.processCodeLine(content, false);
        HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default((HtmlGenerator.HtmlGeneratingVisitor)visitor2, (ASTNode)node, (CharSequence)"code", (CharSequence[])new CharSequence[0], (boolean)false, (int)8, null);
        visitor2.consumeHtml((CharSequence)(lineRunner + content));
        visitor2.consumeTagClose((CharSequence)"code");
    }

    private static final CharSequence processNode$lambda$0(CodeSpanRunnerGeneratingProvider this$0, String $text, boolean $isInsideTable, ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.processChild(it, $text, $isInsideTable);
    }
}

