/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.jcef.commandRunner;

import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.ide.trustedProjects.TrustedProjectsDialog;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/TrustedProjectUtil;", "", "<init>", "()V", "executeIfTrusted", "", "project", "Lcom/intellij/openapi/project/Project;", "block", "Lkotlin/Function0;", "", "confirmProjectIsTrusted", "intellij.markdown"})
public final class TrustedProjectUtil {
    @NotNull
    public static final TrustedProjectUtil INSTANCE = new TrustedProjectUtil();

    private TrustedProjectUtil() {
    }

    public final boolean executeIfTrusted(@NotNull Project project, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (TrustedProjects.isProjectTrusted((Project)project) || this.confirmProjectIsTrusted(project)) {
            block.invoke();
            return true;
        }
        return false;
    }

    private final boolean confirmProjectIsTrusted(Project project) {
        String string = MarkdownBundle.message("markdown.untrusted.project.dialog.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return TrustedProjectsDialog.confirmLoadingUntrustedProject$default((Project)project, null, (String)string, null, null, (int)26, null);
    }
}

