/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.exporter;

import ghidra.app.util.DomainObjectService;
import ghidra.app.util.Option;
import ghidra.app.util.OptionException;
import ghidra.app.util.exporter.Exporter;
import ghidra.app.util.exporter.ProgramTextOptions;
import ghidra.app.util.exporter.ProgramTextWriter;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class AsciiExporter
extends Exporter {
    private ProgramTextOptions options;

    public AsciiExporter() {
        super("Ascii", "txt", new HelpLocation("ExporterPlugin", "ascii"));
    }

    @Override
    public List<Option> getOptions(DomainObjectService domainObjectService) {
        if (this.options == null) {
            this.options = new ProgramTextOptions();
            this.options.setHTML(false);
        }
        return this.options.getOptions();
    }

    @Override
    public void setOptions(List<Option> options) throws OptionException {
        this.options.setOptions(options);
    }

    @Override
    public boolean export(File file, DomainObject domainObj, AddressSetView addressSet, TaskMonitor monitor) throws IOException {
        this.log.clear();
        if (!(domainObj instanceof Program)) {
            this.log.appendMsg("Unsupported type: " + domainObj.getClass().getName());
            return false;
        }
        Program program = (Program)domainObj;
        this.getOptions(() -> program);
        new ProgramTextWriter(file, program, addressSet, monitor, this.options, this.provider);
        return true;
    }
}

