/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableFilter;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import java.util.ArrayList;

public class CodeUnitInfo {
    private static final long serialVersionUID = 1L;
    private static final String[] emptyStringArray = new String[0];
    private static final int[] emptyIntArray = new int[0];
    private static final Address[] emptyAddrArray = new Address[0];
    private static final SourceType[] emptySourceTypeArray = new SourceType[0];
    private int index;
    private boolean hasDynamicSymbol = false;
    private String primarySymbolName;
    private SourceType primarySymbolSource;
    private boolean primarySymbolInFunctionScope = false;
    private String[] functionScopeSymbolNames = emptyStringArray;
    private SourceType[] functionScopeSymbolSources = emptySourceTypeArray;
    private String[] otherSymbolNames = emptyStringArray;
    private SourceType[] otherSymbolSources = emptySourceTypeArray;
    private String[] plateComment = emptyStringArray;
    private String[] preComment = emptyStringArray;
    private String[] postComment = emptyStringArray;
    private String[] eolComment = emptyStringArray;
    private String[] repeatableComment = emptyStringArray;
    private String functionName;
    private String[] functionComments = emptyStringArray;
    private String[] stackVarNames = emptyStringArray;
    private SourceType[] stackVarSources = emptySourceTypeArray;
    private int[] stackOffsets = emptyIntArray;
    private int[] stackVarFUOffsets = emptyIntArray;
    private String[] stackVarComments = emptyStringArray;
    private String[] varNames = emptyStringArray;
    private SourceType[] varSources = emptySourceTypeArray;
    private Address[] varAddrs = emptyAddrArray;
    private int[] varFUOffsets = emptyIntArray;
    private String[] varComments = emptyStringArray;

    public CodeUnitInfo(int index) {
        this.index = index;
    }

    public void setSymbols(Symbol[] symbols) {
        this.primarySymbolName = null;
        ArrayList<String> scopeSymList = new ArrayList<String>();
        ArrayList<SourceType> scopeSymSourceList = new ArrayList<SourceType>();
        ArrayList<String> otherSymList = new ArrayList<String>();
        ArrayList<SourceType> otherSymSourceList = new ArrayList<SourceType>();
        for (Symbol symbol : symbols) {
            SymbolType symbolType = symbol.getSymbolType();
            if (symbol.isDynamic()) {
                this.hasDynamicSymbol = true;
                continue;
            }
            if (symbol.isPrimary()) {
                this.primarySymbolName = symbol.getName();
                this.primarySymbolSource = symbol.getSource();
                this.primarySymbolInFunctionScope = symbolType == SymbolType.FUNCTION;
                continue;
            }
            if (symbolType == SymbolType.FUNCTION) {
                scopeSymList.add(symbol.getName());
                scopeSymSourceList.add(symbol.getSource());
                continue;
            }
            otherSymList.add(symbol.getName());
            otherSymSourceList.add(symbol.getSource());
        }
        this.functionScopeSymbolNames = new String[scopeSymList.size()];
        scopeSymList.toArray(this.functionScopeSymbolNames);
        this.functionScopeSymbolSources = new SourceType[scopeSymSourceList.size()];
        scopeSymSourceList.toArray(this.functionScopeSymbolSources);
        this.otherSymbolNames = new String[otherSymList.size()];
        otherSymList.toArray(this.otherSymbolNames);
        this.otherSymbolSources = new SourceType[otherSymSourceList.size()];
        otherSymSourceList.toArray(this.otherSymbolSources);
    }

    public void setComment(CommentType commentType, String[] comment) {
        switch (commentType) {
            case PLATE: {
                this.plateComment = comment;
                break;
            }
            case PRE: {
                this.preComment = comment;
                break;
            }
            case POST: {
                this.postComment = comment;
                break;
            }
            case REPEATABLE: {
                this.repeatableComment = comment;
                break;
            }
            case EOL: {
                this.eolComment = comment;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported comment type: " + commentType.name());
            }
        }
    }

    public void setFunction(Function function) {
        this.functionName = function.getName();
        this.functionComments = function.getCommentAsArray();
        Variable[] vars = function.getAllVariables();
        Variable[] stackVars = function.getVariables(VariableFilter.STACK_VARIABLE_FILTER);
        this.stackVarNames = new String[stackVars.length];
        this.stackVarSources = new SourceType[stackVars.length];
        this.stackOffsets = new int[stackVars.length];
        this.stackVarFUOffsets = new int[stackVars.length];
        this.stackVarComments = new String[stackVars.length];
        this.setStackVarInfo(stackVars);
        int nonStackVariableCount = vars.length - stackVars.length;
        this.varNames = new String[nonStackVariableCount];
        this.varSources = new SourceType[nonStackVariableCount];
        this.varAddrs = new Address[nonStackVariableCount];
        this.varFUOffsets = new int[nonStackVariableCount];
        this.varComments = new String[nonStackVariableCount];
        this.setNonStackVarInfo(vars);
    }

    public int getIndex() {
        return this.index;
    }

    public boolean hasSymbols() {
        return this.primarySymbolName != null || this.functionScopeSymbolNames.length != 0 || this.otherSymbolNames.length != 0;
    }

    public boolean hasDynamicSymbol() {
        return this.hasDynamicSymbol;
    }

    public String getPrimarySymbolName() {
        return this.primarySymbolName;
    }

    public SourceType getPrimarySymbolSource() {
        return this.primarySymbolSource;
    }

    public boolean isPrimarySymbolInFunctionScope() {
        return this.primarySymbolInFunctionScope;
    }

    public String[] getFunctionScopeSymbolNames() {
        return this.functionScopeSymbolNames;
    }

    public SourceType[] getFunctionScopeSymbolSources() {
        return this.functionScopeSymbolSources;
    }

    public String[] getOtherSymbolNames() {
        return this.otherSymbolNames;
    }

    public SourceType[] getOtherSymbolSources() {
        return this.otherSymbolSources;
    }

    public String[] getPlateComment() {
        return this.plateComment;
    }

    public String[] getPreComment() {
        return this.preComment;
    }

    public String[] getPostComment() {
        return this.postComment;
    }

    public String[] getEOLComment() {
        return this.eolComment;
    }

    public String[] getRepeatableComment() {
        return this.repeatableComment;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String[] getFunctionComments() {
        return this.functionComments;
    }

    public String[] getStackVariableNames() {
        return this.stackVarNames;
    }

    public SourceType[] getStackVariableSources() {
        return this.stackVarSources;
    }

    public int[] getStackOffsets() {
        return this.stackOffsets;
    }

    public int[] getStackVarFirstUseOffsets() {
        return this.stackVarFUOffsets;
    }

    public String[] getStackVariableComments() {
        return this.stackVarComments;
    }

    public String[] getVariableNames() {
        return this.varNames;
    }

    public SourceType[] getVariableSources() {
        return this.varSources;
    }

    public Address[] getVarAddresses() {
        return this.varAddrs;
    }

    public int[] getVarFirstUseOffsets() {
        return this.varFUOffsets;
    }

    public String[] getVariableComments() {
        return this.varComments;
    }

    private void setStackVarInfo(Variable[] vars) {
        for (int i = 0; i < vars.length; ++i) {
            this.stackVarNames[i] = vars[i].getName();
            this.stackVarSources[i] = vars[i].getSource();
            this.stackOffsets[i] = vars[i].getStackOffset();
            this.stackVarFUOffsets[i] = vars[i].getFirstUseOffset();
            this.stackVarComments[i] = vars[i].getComment();
        }
    }

    private void setNonStackVarInfo(Variable[] vars) {
        int variableIndex = 0;
        for (Variable var : vars) {
            if (var.isStackVariable()) continue;
            this.varNames[variableIndex] = var.getName();
            this.varSources[variableIndex] = var.getSource();
            Varnode firstVarnode = var.getFirstStorageVarnode();
            this.varAddrs[variableIndex] = firstVarnode != null ? firstVarnode.getAddress() : Address.NO_ADDRESS;
            this.varFUOffsets[variableIndex] = var.getFirstUseOffset();
            this.varComments[variableIndex] = var.getComment();
            ++variableIndex;
        }
    }
}

