/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.register;

import ghidra.program.model.lang.Register;

class RegisterWrapper
implements Comparable<RegisterWrapper> {
    Register register;
    String displayName;

    RegisterWrapper(Register register) {
        this.register = register;
        this.displayName = register.getName() + " (" + register.getBitLength() + this.getAliases() + ")";
    }

    private String getAliases() {
        StringBuffer buf = new StringBuffer();
        for (String alias : this.register.getAliases()) {
            buf.append(buf.length() == 0 ? "; " : ", ");
            buf.append(alias);
        }
        return buf.toString();
    }

    public String toString() {
        return this.displayName;
    }

    @Override
    public int compareTo(RegisterWrapper o) {
        return this.register.getName().compareToIgnoreCase(o.register.getName());
    }
}

