/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.comments;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ProgramLocationActionContext;
import ghidra.app.plugin.core.comments.CommentsDialog;
import ghidra.framework.PluggableServiceRegistry;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CommentType;
import ghidra.program.util.CodeUnitLocation;
import ghidra.program.util.CommentTypeUtils;
import ghidra.program.util.FunctionLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocation;
import ghidra.util.HelpLocation;

public class CommentsActionFactory {
    public static DockingAction getSetCommentsAction(CommentsDialog dialog, String name, String actionName, CommentType commentType) {
        CommentsActionFactory factory = (CommentsActionFactory)PluggableServiceRegistry.getPluggableService(CommentsActionFactory.class);
        return factory.doGetSetCommentsAction(dialog, name, actionName, commentType);
    }

    public static DockingAction getEditCommentsAction(CommentsDialog dialog, String name) {
        CommentsActionFactory factory = (CommentsActionFactory)PluggableServiceRegistry.getPluggableService(CommentsActionFactory.class);
        return factory.doGetEditCommentsAction(dialog, name);
    }

    public static boolean isCommentSupported(ProgramLocation loc) {
        CommentsActionFactory factory = (CommentsActionFactory)PluggableServiceRegistry.getPluggableService(CommentsActionFactory.class);
        return factory.doIsCommentSupported(loc);
    }

    protected DockingAction doGetSetCommentsAction(CommentsDialog dialog, String name, String actionName, CommentType commentType) {
        return new SetCommentsAction(dialog, name, actionName, commentType);
    }

    protected DockingAction doGetEditCommentsAction(CommentsDialog dialog, String name) {
        return new EditCommentsAction(dialog, name);
    }

    protected boolean doIsCommentSupported(ProgramLocation loc) {
        if (loc == null || loc.getAddress() == null) {
            return false;
        }
        return loc instanceof CodeUnitLocation || loc instanceof FunctionLocation && !(loc instanceof VariableLocation);
    }

    static {
        PluggableServiceRegistry.registerPluggableService(CommentsActionFactory.class, (Object)new CommentsActionFactory());
    }

    private static class SetCommentsAction
    extends DockingAction {
        private final CommentsDialog dialog;
        private final CommentType commentType;

        SetCommentsAction(CommentsDialog dialog, String name, String actionName, CommentType commentType) {
            super(actionName, name);
            this.dialog = dialog;
            this.commentType = commentType;
            this.setPopupMenuData(new MenuData(new String[]{"Comments", actionName + "..."}, "comments"));
            this.setHelpLocation(new HelpLocation("CommentsPlugin", "Edit_Comments"));
        }

        protected CommentType getEditCommentType(ActionContext context) {
            return this.commentType;
        }

        public void actionPerformed(ActionContext context) {
            CodeUnit cu = this.getCodeUnit(context);
            CommentType type = this.getEditCommentType(context);
            this.dialog.showDialog(cu, type);
        }

        public boolean isEnabledForContext(ActionContext actionContext) {
            ProgramLocation loc = this.getLocationForContext(actionContext);
            if (!CommentsActionFactory.isCommentSupported(loc)) {
                return false;
            }
            return CommentTypeUtils.isCommentAllowed((CodeUnit)this.getCodeUnit(actionContext), (ProgramLocation)loc);
        }

        public boolean isValidContext(ActionContext context) {
            return context instanceof ListingActionContext;
        }

        protected CodeUnit getCodeUnit(ActionContext actionContext) {
            ProgramLocationActionContext context = (ProgramLocationActionContext)actionContext;
            return context.getCodeUnit();
        }

        protected ProgramLocation getLocationForContext(ActionContext actionContext) {
            ProgramLocationActionContext context = (ProgramLocationActionContext)actionContext;
            return context.getLocation();
        }
    }

    private static class EditCommentsAction
    extends SetCommentsAction {
        private static final String[] EDIT_MENUPATH = new String[]{"Comments", "Set..."};

        EditCommentsAction(CommentsDialog dialog, String name) {
            super(dialog, name, "Edit Comments", null);
            this.setPopupMenuData(new MenuData(EDIT_MENUPATH, "comments"));
            this.setKeyBindingData(new KeyBindingData(59, 0));
        }

        @Override
        protected CommentType getEditCommentType(ActionContext context) {
            CodeUnit cu = this.getCodeUnit(context);
            return CommentTypeUtils.getCommentType((CodeUnit)cu, (ProgramLocation)this.getLocationForContext(context), null);
        }
    }
}

