/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.checksums;

import ghidra.app.plugin.core.checksums.ChecksumAlgorithm;
import ghidra.app.plugin.core.checksums.ComputeChecksumsProvider;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.util.MemoryByteIterator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public abstract class DigestChecksumAlgorithm
extends ChecksumAlgorithm {
    MessageDigest digester;

    public DigestChecksumAlgorithm(String type) throws NoSuchAlgorithmException {
        super(type);
        this.digester = MessageDigest.getInstance(this.name);
    }

    @Override
    public void updateChecksum(Memory memory, AddressSetView addrSet, TaskMonitor monitor, ComputeChecksumsProvider provider) throws MemoryAccessException, CancelledException {
        MemoryByteIterator bytes = new MemoryByteIterator(memory, addrSet);
        while (bytes.hasNext()) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            this.digester.update(bytes.next());
        }
        this.checksum = this.digester.digest();
    }
}

