/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.stringable;

import ghidra.feature.vt.api.util.Stringable;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.GlobalNamespace;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class MultipleSymbolStringable
extends Stringable {
    public static final String SHORT_NAME = "MULTI_SYM";
    private ArrayList<SymbolInfo> symbolInfos = new ArrayList();

    public MultipleSymbolStringable() {
        this((List<Symbol>)null);
    }

    public MultipleSymbolStringable(Symbol[] symbols) {
        this(Arrays.asList(symbols));
    }

    public MultipleSymbolStringable(List<Symbol> symbols) {
        super(SHORT_NAME);
        if (symbols == null) {
            return;
        }
        int count = symbols.size();
        for (int index = 0; index < count; ++index) {
            Symbol symbol = symbols.get(index);
            this.symbolInfos.add(new SymbolInfo(symbol));
        }
    }

    @Override
    public String getDisplayString() {
        StringBuilder buildy = new StringBuilder();
        for (SymbolInfo symbolInfo : this.symbolInfos) {
            buildy.append(symbolInfo.getDisplayString()).append('\n');
        }
        return buildy.toString();
    }

    public String[] getNames() {
        String[] names = new String[this.symbolInfos.size()];
        int i = 0;
        for (SymbolInfo symbolInfo : this.symbolInfos) {
            names[i++] = symbolInfo.getName();
        }
        return names;
    }

    public boolean contains(Symbol symbol) {
        SymbolInfo symbolInfo = new SymbolInfo(symbol);
        for (SymbolInfo currentSymbolInfo : this.symbolInfos) {
            if (!symbolInfo.equals(currentSymbolInfo)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String doConvertToString(Program program) {
        if (this.symbolInfos == null || this.symbolInfos.size() == 0) {
            return "";
        }
        StringBuilder buildy = new StringBuilder();
        for (SymbolInfo symbolInfo : this.symbolInfos) {
            symbolInfo.convertToString(buildy);
            buildy.append("\n");
        }
        return buildy.toString();
    }

    @Override
    protected void doRestoreFromString(String string, Program program) {
        StringTokenizer tokenizer = new StringTokenizer(string, "\n");
        while (tokenizer.hasMoreTokens()) {
            this.symbolInfos.add(new SymbolInfo(tokenizer.nextToken()));
        }
    }

    public List<Symbol> setSymbols(Program program, Address address, boolean setAsPrimary) throws DuplicateNameException, InvalidInputException {
        SymbolTable symbolTable = program.getSymbolTable();
        ArrayList<Symbol> symbols = new ArrayList<Symbol>();
        for (SymbolInfo symbolInfo : this.symbolInfos) {
            if (symbolInfo.isDynamic) continue;
            String name = symbolInfo.symbolName;
            SourceType sourceType = symbolInfo.sourceType;
            Namespace namespace = this.getNamespaceForNewLabel(program, symbolInfo, address);
            Symbol symbol = symbolTable.getSymbol(name, address, namespace);
            if (symbol != null) {
                if (symbol.getSource() != sourceType) {
                    symbol.setSource(sourceType);
                }
                symbols.add(symbol);
            } else {
                symbol = this.createSymbol(program, address, symbolInfo);
                symbols.add(symbol);
            }
            if (!setAsPrimary) continue;
            symbol.setPrimary();
            setAsPrimary = false;
        }
        return symbols;
    }

    private Symbol createSymbol(Program program, Address address, SymbolInfo symbolInfo) throws DuplicateNameException, InvalidInputException {
        Namespace namespace = this.getNamespaceForNewLabel(program, symbolInfo, address);
        return program.getSymbolTable().createLabel(address, symbolInfo.getName(), namespace, symbolInfo.sourceType);
    }

    private Namespace getNamespaceForNewLabel(Program program, SymbolInfo symbolInfo, Address address) throws DuplicateNameException, InvalidInputException {
        Function f;
        if (symbolInfo.isNamespaceFunctionBased && (f = program.getFunctionManager().getFunctionContaining(address)) != null) {
            return f;
        }
        Namespace namespace = program.getGlobalNamespace();
        for (NamespaceInfo info : symbolInfo.namespaceInfos) {
            namespace = this.getOrCreateNamespace(program, info, namespace);
        }
        return namespace;
    }

    private Namespace getOrCreateNamespace(Program program, NamespaceInfo info, Namespace parent) throws DuplicateNameException, InvalidInputException {
        Namespace namespace = program.getSymbolTable().getNamespace(info.name, parent);
        if (namespace != null) {
            return namespace;
        }
        return this.createNamespace(program, info, parent);
    }

    private Namespace createNamespace(Program program, NamespaceInfo info, Namespace namespace) throws DuplicateNameException, InvalidInputException {
        SymbolTable symbolTable = program.getSymbolTable();
        String name = info.name;
        SymbolType type = info.symbolType;
        SourceType sourceType = info.sourceType;
        if (type == SymbolType.LIBRARY) {
            return symbolTable.createExternalLibrary(name, sourceType);
        }
        if (type == SymbolType.CLASS) {
            return symbolTable.createClass(namespace, name, sourceType);
        }
        return symbolTable.createNameSpace(namespace, name, sourceType);
    }

    @Override
    public boolean equals(Object obj) {
        int otherCount;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MultipleSymbolStringable other = (MultipleSymbolStringable)obj;
        int count = this.symbolInfos.size();
        if (count != (otherCount = other.symbolInfos.size())) {
            return false;
        }
        return this.symbolInfos.equals(other.symbolInfos);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.symbolInfos == null ? 0 : this.symbolInfos.hashCode());
        return result;
    }

    public boolean isEmpty() {
        return this.symbolInfos.isEmpty();
    }

    public boolean containsDynamic() {
        for (SymbolInfo info : this.symbolInfos) {
            if (!SymbolUtilities.isDynamicSymbolPattern((String)info.getName(), (boolean)true)) continue;
            return true;
        }
        return false;
    }

    public boolean isAllDynamic() {
        for (SymbolInfo info : this.symbolInfos) {
            if (SymbolUtilities.isDynamicSymbolPattern((String)info.getName(), (boolean)true)) continue;
            return false;
        }
        return true;
    }

    private class SymbolInfo {
        private final String symbolName;
        private final SourceType sourceType;
        private final boolean isDynamic;
        private final List<NamespaceInfo> namespaceInfos = new ArrayList<NamespaceInfo>();
        private boolean isNamespaceFunctionBased;

        SymbolInfo(Symbol symbol) {
            this.symbolName = symbol.getName();
            this.sourceType = symbol.getSource();
            this.isDynamic = symbol.isDynamic();
            for (Namespace namespace = symbol.getParentNamespace(); namespace != null; namespace = namespace.getParentNamespace()) {
                if (namespace instanceof Function) {
                    this.isNamespaceFunctionBased = true;
                    break;
                }
                if (namespace instanceof GlobalNamespace) break;
                this.namespaceInfos.add(new NamespaceInfo(MultipleSymbolStringable.this, namespace));
            }
            Collections.reverse(this.namespaceInfos);
        }

        SymbolInfo(String string) {
            StringTokenizer tok = new StringTokenizer(string, "\t");
            this.symbolName = tok.nextToken();
            String sourceName = tok.nextToken();
            this.sourceType = SourceType.valueOf((String)sourceName);
            this.isDynamic = Boolean.parseBoolean(tok.nextToken());
            while (tok.hasMoreTokens()) {
                this.getNamespaceInfo(tok);
            }
        }

        private void getNamespaceInfo(StringTokenizer tok) {
            String name = tok.nextToken();
            int id = Integer.parseInt(tok.nextToken());
            SymbolType type = SymbolType.getSymbolType((int)id);
            String sourceName = tok.nextToken();
            SourceType nameSpaceSourceType = SourceType.valueOf((String)sourceName);
            this.namespaceInfos.add(new NamespaceInfo(MultipleSymbolStringable.this, name, type, nameSpaceSourceType));
        }

        void convertToString(StringBuilder builder) {
            builder.append(this.symbolName).append("\t");
            builder.append(this.sourceType.name()).append("\t");
            builder.append(Boolean.toString(this.isDynamic)).append("\t");
            for (NamespaceInfo info : this.namespaceInfos) {
                builder.append(info.name).append("\t");
                builder.append(info.symbolType.getID()).append("\t");
                builder.append(info.sourceType.name()).append("\t");
            }
        }

        String getName() {
            return this.symbolName;
        }

        String getDisplayString() {
            return this.symbolName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.sourceType == null ? 0 : this.sourceType.hashCode());
            result = 31 * result + (this.symbolName == null ? 0 : this.symbolName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SymbolInfo other = (SymbolInfo)obj;
            if (!SystemUtilities.isEqual((Object)this.sourceType, (Object)other.sourceType)) {
                return false;
            }
            if (!SystemUtilities.isEqual((Object)this.symbolName, (Object)other.symbolName)) {
                return false;
            }
            if (this.namespaceInfos.size() != other.namespaceInfos.size()) {
                return false;
            }
            for (int i = 0; i < this.namespaceInfos.size(); ++i) {
                if (this.namespaceInfos.get(i).equals(other.namespaceInfos.get(i))) continue;
                return false;
            }
            return true;
        }
    }

    private class NamespaceInfo {
        String name;
        SymbolType symbolType;
        SourceType sourceType;

        public NamespaceInfo(MultipleSymbolStringable multipleSymbolStringable, Namespace namespace) {
            this.name = namespace.getName();
            this.symbolType = namespace.getSymbol().getSymbolType();
            this.sourceType = namespace.getSymbol().getSource();
        }

        public NamespaceInfo(MultipleSymbolStringable multipleSymbolStringable, String name, SymbolType type, SourceType sourceType) {
            this.name = name;
            this.symbolType = type;
            this.sourceType = sourceType;
        }
    }
}

