/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.field;

import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextField;
import docking.widgets.fieldpanel.internal.FieldBackgroundColorManager;
import docking.widgets.fieldpanel.internal.PaintContext;
import docking.widgets.fieldpanel.support.DefaultRowColLocation;
import docking.widgets.fieldpanel.support.FieldHighlightFactory;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.Highlight;
import docking.widgets.fieldpanel.support.RowColLocation;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;

public class ClippingTextField
implements TextField {
    private static int DOT_DOT_DOT_WIDTH = 12;
    private FieldElement originalElement;
    private FieldElement textElement;
    protected int startX;
    private int width;
    private int preferredWidth;
    private int numDataRows;
    private String fullText;
    private boolean isClipped;
    private FieldHighlightFactory hlFactory;
    private boolean isPrimary;

    public ClippingTextField(int startX, int width, FieldElement textElement, FieldHighlightFactory hlFactory) {
        this(startX, width, textElement, 1, hlFactory);
    }

    public ClippingTextField(int startX, int width, FieldElement textElement, int numDataRows, FieldHighlightFactory hlFactory) {
        this.startX = startX;
        this.width = width;
        this.numDataRows = numDataRows;
        this.textElement = textElement;
        this.hlFactory = hlFactory;
        this.preferredWidth = textElement.getStringWidth();
        this.clip(width);
    }

    private void clip(int availableWidth) {
        this.originalElement = this.textElement;
        int w = this.textElement.getStringWidth();
        if (w <= availableWidth) {
            return;
        }
        this.isClipped = true;
        int length = this.textElement.getMaxCharactersForWidth(this.width - DOT_DOT_DOT_WIDTH);
        this.textElement = this.textElement.substring(0, length);
    }

    @Override
    public boolean contains(int x, int y) {
        return x >= this.startX && x < this.startX + this.width && y >= -this.textElement.getHeightAbove() && y < this.textElement.getHeightBelow();
    }

    @Override
    public int getCol(int row, int x) {
        int xPos = Math.max(x - this.startX, 0);
        return this.textElement.getMaxCharactersForWidth(xPos);
    }

    @Override
    public Rectangle getCursorBounds(int row, int col) {
        if (row != 0) {
            return null;
        }
        int x = this.findX(col) + this.startX;
        return new Rectangle(x, -this.textElement.getHeightAbove(), 2, this.textElement.getHeightAbove() + this.textElement.getHeightBelow());
    }

    @Override
    public int getHeight() {
        return this.textElement.getHeightAbove() + this.textElement.getHeightBelow();
    }

    @Override
    public int getNumCols(int row) {
        return this.getNumCols();
    }

    private int getNumCols() {
        return this.textElement.length() + 1;
    }

    @Override
    public int getNumDataRows() {
        return this.numDataRows;
    }

    @Override
    public int getNumRows() {
        return 1;
    }

    @Override
    public int getRow(int y) {
        return 0;
    }

    @Override
    public int getScrollableUnitIncrement(int topOfScreen, int direction, int max) {
        if (topOfScreen < -this.getHeightAbove() || topOfScreen > this.getHeightBelow()) {
            return max;
        }
        if (direction > 0) {
            return this.getHeightBelow() - topOfScreen;
        }
        return -this.getHeightAbove() - topOfScreen;
    }

    @Override
    public int getStartX() {
        return this.startX;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    @Override
    public int getX(int row, int col) {
        if (col >= this.getNumCols()) {
            col = this.getNumCols() - 1;
        }
        return this.findX(col) + this.startX;
    }

    @Override
    public int getY(int row) {
        return -this.getHeightAbove();
    }

    @Override
    public boolean isPrimary() {
        return this.isPrimary;
    }

    @Override
    public void setPrimary(boolean b) {
        this.isPrimary = b;
    }

    @Override
    public boolean isValid(int row, int col) {
        if (row != 0) {
            return false;
        }
        return col >= 0 && col < this.getNumCols();
    }

    private String getString() {
        if (this.fullText == null) {
            this.fullText = this.originalElement.getText();
        }
        return this.fullText;
    }

    @Override
    public void paint(JComponent c, Graphics g, PaintContext context, Rectangle clip, FieldBackgroundColorManager colorManager, RowColLocation cursorLoc, int rowHeight) {
        if (context.isPrinting()) {
            this.print(g, context);
        } else {
            this.paintSelection(g, colorManager, 0, rowHeight);
            this.paintHighlights(g, cursorLoc);
            this.paintText(c, g, context);
            this.paintCursor(g, context.getCursorColor(), cursorLoc);
        }
    }

    void print(Graphics g, PaintContext context) {
        this.textElement.paint(null, g, this.startX, 0);
        if (this.isClipped) {
            this.paintDots(g, this.startX + this.textElement.getStringWidth());
        }
    }

    void paintText(JComponent c, Graphics g, PaintContext context) {
        this.textElement.paint(c, g, this.startX, 0);
        if (this.isClipped) {
            g.setColor(this.textElement.getColor(this.textElement.length() - 1));
            this.paintDots(g, this.startX + this.textElement.getStringWidth());
        }
    }

    private void paintDots(Graphics g, int x) {
        int pos = 1;
        for (int i = 0; i < 3; ++i) {
            if (pos >= DOT_DOT_DOT_WIDTH - 2) continue;
            g.drawRect(x + pos, -2, 1, 1);
            pos += 4;
        }
    }

    private void paintHighlights(Graphics g, RowColLocation cursorLoc) {
        int cursorTextOffset = -1;
        if (cursorLoc != null) {
            cursorTextOffset = this.screenLocationToTextOffset(cursorLoc.row(), cursorLoc.col());
        }
        this.paintHighlights(g, this.hlFactory.createHighlights(this, this.getString(), cursorTextOffset));
    }

    protected void paintSelection(Graphics g, FieldBackgroundColorManager colorManager, int row, int rowHeight) {
        List<Highlight> selections = colorManager.getSelectionHighlights(row);
        if (selections.isEmpty()) {
            return;
        }
        int textLength = this.getString().length();
        int endTextPos = this.findX(textLength);
        for (Highlight highlight : selections) {
            g.setColor(highlight.getColor());
            int startCol = highlight.getStart();
            int endCol = highlight.getEnd();
            int x1 = this.findX(startCol);
            int x2 = endCol < textLength ? this.findX(endCol) : endTextPos;
            g.fillRect(this.startX + x1, -this.getHeightAbove(), x2 - x1, this.getHeight());
        }
        Color rightMarginColor = colorManager.getPaddingColor(1);
        if (rightMarginColor != null) {
            g.setColor(rightMarginColor);
            g.fillRect(this.startX + endTextPos, -this.getHeightAbove(), this.width - endTextPos, rowHeight);
        }
    }

    protected void paintHighlights(Graphics g, Highlight[] highlights) {
        for (Highlight highlight : highlights) {
            int startCol = Math.max(highlight.getStart(), 0);
            int endCol = Math.min(highlight.getEnd(), this.getString().length());
            Color c = highlight.getColor();
            if (endCol < startCol) continue;
            int start = this.findX(startCol);
            int end = this.findX(endCol + 1);
            if (this.isClipped && endCol >= this.getNumCols()) {
                end += DOT_DOT_DOT_WIDTH;
            }
            g.setColor(c);
            g.fillRect(this.startX + start, -this.getHeightAbove(), end - start, this.getHeight());
        }
    }

    protected void paintCursor(Graphics g, Color cursorColor, RowColLocation cursorLoc) {
        if (cursorLoc != null) {
            g.setColor(cursorColor);
            if (cursorLoc.col() < this.getNumCols()) {
                int x = this.startX + this.findX(cursorLoc.col());
                g.fillRect(x, -this.getHeightAbove(), 2, this.getHeight());
            }
        }
    }

    @Override
    public RowColLocation screenToDataLocation(int screenRow, int screenColumn) {
        return this.originalElement.getDataLocationForCharacterIndex(screenColumn);
    }

    @Override
    public RowColLocation dataToScreenLocation(int dataRow, int dataColumn) {
        int column = this.textElement.getCharacterIndexForDataLocation(dataRow, dataColumn);
        if (column < 0) {
            column = this.textElement.getCharacterIndexForDataLocation(dataRow, dataColumn - 3);
            if (column < 0) {
                return new DefaultRowColLocation(0, this.textElement.length());
            }
            return new RowColLocation(0, this.textElement.length());
        }
        return new RowColLocation(0, column);
    }

    private int findX(int col) {
        if (col > this.textElement.length()) {
            col = this.textElement.length();
        }
        return this.textElement.substring(0, col).getStringWidth();
    }

    @Override
    public boolean isClipped() {
        return this.isClipped;
    }

    @Override
    public int getHeightAbove() {
        return this.textElement.getHeightAbove();
    }

    @Override
    public int getHeightBelow() {
        return this.textElement.getHeightBelow();
    }

    @Override
    public void rowHeightChanged(int heightAbove, int heightBelow) {
    }

    @Override
    public String getText() {
        return this.getString();
    }

    @Override
    public String getTextWithLineSeparators() {
        return this.getString();
    }

    @Override
    public RowColLocation textOffsetToScreenLocation(int textOffset) {
        return new RowColLocation(0, Math.min(textOffset, this.textElement.getText().length()));
    }

    @Override
    public int screenLocationToTextOffset(int row, int col) {
        return Math.min(this.textElement.getText().length(), col);
    }

    public Object getClickedObject(FieldLocation fieldLocation) {
        return this.getFieldElement(fieldLocation.row, fieldLocation.col);
    }

    @Override
    public FieldElement getFieldElement(int screenRow, int screenColumn) {
        return this.originalElement.getFieldElement(screenColumn);
    }

    public String toString() {
        return this.getText();
    }
}

