/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database.annotproc;

import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.database.annotproc.AccessSpec;
import ghidra.util.database.annotproc.DBAnnotatedColumnValidator;
import ghidra.util.database.annotproc.DBAnnotatedFieldValidator;
import ghidra.util.database.annotproc.ValidationContext;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;

public class DBAnnotatedObjectValidator {
    private final ValidationContext ctx;
    private final TypeElement type;
    private final Map<String, DBAnnotatedFieldValidator> fieldsByName = new LinkedHashMap<String, DBAnnotatedFieldValidator>();
    private final Map<String, DBAnnotatedColumnValidator> columnsByName = new LinkedHashMap<String, DBAnnotatedColumnValidator>();

    public DBAnnotatedObjectValidator(ValidationContext ctx, TypeElement type) {
        this.ctx = ctx;
        this.type = type;
    }

    public void addAnnotatedField(VariableElement field) {
        DBAnnotatedField annotation = field.getAnnotation(DBAnnotatedField.class);
        assert (annotation != null);
        this.fieldsByName.put(annotation.column(), new DBAnnotatedFieldValidator(this.ctx, field));
    }

    public void addAnnotatedColumn(VariableElement column) {
        DBAnnotatedColumn annotation = column.getAnnotation(DBAnnotatedColumn.class);
        assert (annotation != null);
        this.columnsByName.put(annotation.value(), new DBAnnotatedColumnValidator(this.ctx, column));
    }

    public void validate() {
        DBAnnotatedObjectInfo annotation = this.type.getAnnotation(DBAnnotatedObjectInfo.class);
        if (annotation != null && this.type.getKind() != ElementKind.CLASS) {
            this.ctx.messager.printMessage(Diagnostic.Kind.ERROR, String.format("@%s cannot be applied to an interface", DBAnnotatedObjectInfo.class.getSimpleName()), this.type);
        } else if (annotation != null && this.type.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            this.ctx.messager.printMessage(Diagnostic.Kind.ERROR, String.format("@%s cannot be applied to an abstract class", DBAnnotatedObjectInfo.class.getSimpleName()), this.type);
        }
        if (annotation != null && !this.ctx.isSubclass(this.type, this.ctx.DB_ANNOTATED_OBJECT_ELEM)) {
            this.ctx.messager.printMessage(Diagnostic.Kind.ERROR, String.format("@%s can only be applied to subclasses of %s", "DBAnnotatedObject", DBAnnotatedObjectInfo.class.getSimpleName()));
        }
        if (annotation == null && !this.type.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            this.ctx.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Non-abstract subclasses of %s must have @%s annotation", "DBAnnotatedObject", DBAnnotatedObjectInfo.class.getSimpleName()), this.type);
        }
        if (annotation != null && annotation.version() < 0) {
            this.ctx.messager.printMessage(Diagnostic.Kind.ERROR, String.format("@%s.version cannot be negative", DBAnnotatedObjectInfo.class.getSimpleName()), this.type);
        }
        this.validateFields();
        this.validateColumns();
        this.checkMissing();
    }

    protected void validateFields() {
        for (DBAnnotatedFieldValidator fv : this.fieldsByName.values()) {
            fv.validate();
        }
    }

    protected void validateColumns() {
        for (DBAnnotatedColumnValidator cv : this.columnsByName.values()) {
            cv.validate();
        }
    }

    protected void checkMissing() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        names.addAll(this.fieldsByName.keySet());
        names.addAll(this.columnsByName.keySet());
        for (String n : names) {
            DBAnnotatedFieldValidator fv = this.fieldsByName.get(n);
            DBAnnotatedColumnValidator cv = this.columnsByName.get(n);
            if (fv == null && cv != null && !this.type.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                this.ctx.messager.printMessage(Diagnostic.Kind.ERROR, String.format("@%s is missing corresponding @%s of the same column name: %s", DBAnnotatedColumn.class.getSimpleName(), DBAnnotatedField.class.getSimpleName(), n), cv.column);
            }
            if (fv != null && cv == null && !this.type.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                this.ctx.messager.printMessage(Diagnostic.Kind.WARNING, String.format("@%s is missing corresponding @%s of the same column name: %s", DBAnnotatedField.class.getSimpleName(), DBAnnotatedColumn.class.getSimpleName(), n), fv.field);
            }
            if (fv == null || cv == null) continue;
            this.checkAccess(fv.field, cv.column, n);
        }
    }

    protected void checkAccess(VariableElement field, VariableElement column, String name) {
        AccessSpec columnSpec;
        AccessSpec fieldSpec = AccessSpec.get(field.getModifiers());
        if (!AccessSpec.isSameOrMorePermissive(fieldSpec, columnSpec = AccessSpec.get(column.getModifiers()))) {
            this.ctx.messager.printMessage(Diagnostic.Kind.WARNING, String.format("field with @%s should have same or greater access than field with corresponding @%s for column name: %s", DBAnnotatedColumn.class.getSimpleName(), DBAnnotatedField.class.getSimpleName(), name), column);
        }
    }
}

