/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.pagedump;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ExceptionRecord
implements StructConverter {
    public static final String NAME = "PAGEDUMP_EXCEPTION_RECORD";
    private int exceptionCode;
    private int exceptionFlags;
    private long exceptionRecord;
    private long exceptionAddress;
    private int numberOfParameters;
    private DumpFileReader reader;
    private long index;

    ExceptionRecord(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setExceptionCode(this.reader.readNextInt());
        this.setExceptionFlags(this.reader.readNextInt());
        this.setExceptionRecord(this.reader.readNextPointer());
        this.setExceptionAddress(this.reader.readNextPointer());
        this.setNumberOfParameters(this.reader.readNextInt());
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(DWORD, 4, "ExceptionCode", null);
        struct.add(DWORD, 4, "ExceptionFlags", null);
        struct.add(DWORD, 4, "ExceptionRecord", null);
        struct.add(DWORD, 4, "ExceptionAddress", null);
        struct.add(DWORD, 4, "NumberOfParameters", null);
        struct.setCategoryPath(new CategoryPath("/MDMP"));
        return struct;
    }

    public int getExceptionCode() {
        return this.exceptionCode;
    }

    public void setExceptionCode(int exceptionCode) {
        this.exceptionCode = exceptionCode;
    }

    public int getExceptionFlags() {
        return this.exceptionFlags;
    }

    public void setExceptionFlags(int exceptionFlags) {
        this.exceptionFlags = exceptionFlags;
    }

    public long getExceptionRecord() {
        return this.exceptionRecord;
    }

    public void setExceptionRecord(long exceptionRecord) {
        this.exceptionRecord = exceptionRecord;
    }

    public long getExceptionAddress() {
        return this.exceptionAddress;
    }

    public void setExceptionAddress(long exceptionAddress) {
        this.exceptionAddress = exceptionAddress;
    }

    public int getNumberOfParameters() {
        return this.numberOfParameters;
    }

    public void setNumberOfParameters(int numberOfParameters) {
        this.numberOfParameters = numberOfParameters;
    }
}

