#!/bin/bash

# SPDX-FileCopyrightText: Copyright (c) 2022 NVIDIA CORPORATION & AFFILIATES. All rights reserved. 
# SPDX-License-Identifier: LicenseRef-NvidiaProprietary
#
# NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
# property and proprietary rights in and to this material, related
# documentation and any modifications thereto. Any use, reproduction, 
# disclosure or distribution of this material and related documentation 
# without an express license agreement from NVIDIA CORPORATION or 
# its affiliates is strictly prohibited.

sudo_location=$(command -v sudo) 

user=$(id -un 2>/dev/null || true)
sudo_cmd=""
if [ "$user" != "root" ]; then
	if [ -n "$sudo_location" ]; then
		sudo_cmd='sudo'
	else
		cat >&2 <<-'EOF'
            Error: "sudo" is not installed.
			If you don't have root access, please use install-dependencies-without-root.sh
		EOF
		exit 1
	fi
fi

script_dir=$(cd -- "$(dirname -- "${BASH_SOURCE[0]}")" &>/dev/null && pwd)

if grep -qs "debian" /etc/os-release 2>/dev/null; then
    $sudo_cmd "$script_dir"/Debian/install-dependencies.sh
elif [[ -f /etc/redhat-release ]]; then
    $sudo_cmd "$script_dir"/RHEL/install-dependencies.sh
else
    echo "Unsupported OS for dependencies installer." >/dev/tty
fi
