﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/workspaces/WorkSpaces_EXPORTS.h>
#include <aws/workspaces/model/AssociationState.h>
#include <aws/workspaces/model/AssociationStateReason.h>
#include <aws/workspaces/model/BundleAssociatedResourceType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace WorkSpaces {
namespace Model {

/**
 * <p>Describes the association between an application and a bundle
 * resource.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/BundleResourceAssociation">AWS
 * API Reference</a></p>
 */
class BundleResourceAssociation {
 public:
  AWS_WORKSPACES_API BundleResourceAssociation() = default;
  AWS_WORKSPACES_API BundleResourceAssociation(Aws::Utils::Json::JsonView jsonValue);
  AWS_WORKSPACES_API BundleResourceAssociation& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_WORKSPACES_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The identifier of the associated resource.</p>
   */
  inline const Aws::String& GetAssociatedResourceId() const { return m_associatedResourceId; }
  inline bool AssociatedResourceIdHasBeenSet() const { return m_associatedResourceIdHasBeenSet; }
  template <typename AssociatedResourceIdT = Aws::String>
  void SetAssociatedResourceId(AssociatedResourceIdT&& value) {
    m_associatedResourceIdHasBeenSet = true;
    m_associatedResourceId = std::forward<AssociatedResourceIdT>(value);
  }
  template <typename AssociatedResourceIdT = Aws::String>
  BundleResourceAssociation& WithAssociatedResourceId(AssociatedResourceIdT&& value) {
    SetAssociatedResourceId(std::forward<AssociatedResourceIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The resource type of the associated resources.</p>
   */
  inline BundleAssociatedResourceType GetAssociatedResourceType() const { return m_associatedResourceType; }
  inline bool AssociatedResourceTypeHasBeenSet() const { return m_associatedResourceTypeHasBeenSet; }
  inline void SetAssociatedResourceType(BundleAssociatedResourceType value) {
    m_associatedResourceTypeHasBeenSet = true;
    m_associatedResourceType = value;
  }
  inline BundleResourceAssociation& WithAssociatedResourceType(BundleAssociatedResourceType value) {
    SetAssociatedResourceType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the bundle.</p>
   */
  inline const Aws::String& GetBundleId() const { return m_bundleId; }
  inline bool BundleIdHasBeenSet() const { return m_bundleIdHasBeenSet; }
  template <typename BundleIdT = Aws::String>
  void SetBundleId(BundleIdT&& value) {
    m_bundleIdHasBeenSet = true;
    m_bundleId = std::forward<BundleIdT>(value);
  }
  template <typename BundleIdT = Aws::String>
  BundleResourceAssociation& WithBundleId(BundleIdT&& value) {
    SetBundleId(std::forward<BundleIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time the association is created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreated() const { return m_created; }
  inline bool CreatedHasBeenSet() const { return m_createdHasBeenSet; }
  template <typename CreatedT = Aws::Utils::DateTime>
  void SetCreated(CreatedT&& value) {
    m_createdHasBeenSet = true;
    m_created = std::forward<CreatedT>(value);
  }
  template <typename CreatedT = Aws::Utils::DateTime>
  BundleResourceAssociation& WithCreated(CreatedT&& value) {
    SetCreated(std::forward<CreatedT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time the association status was last updated.</p>
   */
  inline const Aws::Utils::DateTime& GetLastUpdatedTime() const { return m_lastUpdatedTime; }
  inline bool LastUpdatedTimeHasBeenSet() const { return m_lastUpdatedTimeHasBeenSet; }
  template <typename LastUpdatedTimeT = Aws::Utils::DateTime>
  void SetLastUpdatedTime(LastUpdatedTimeT&& value) {
    m_lastUpdatedTimeHasBeenSet = true;
    m_lastUpdatedTime = std::forward<LastUpdatedTimeT>(value);
  }
  template <typename LastUpdatedTimeT = Aws::Utils::DateTime>
  BundleResourceAssociation& WithLastUpdatedTime(LastUpdatedTimeT&& value) {
    SetLastUpdatedTime(std::forward<LastUpdatedTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the bundle resource association.</p>
   */
  inline AssociationState GetState() const { return m_state; }
  inline bool StateHasBeenSet() const { return m_stateHasBeenSet; }
  inline void SetState(AssociationState value) {
    m_stateHasBeenSet = true;
    m_state = value;
  }
  inline BundleResourceAssociation& WithState(AssociationState value) {
    SetState(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The reason the association deployment failed.</p>
   */
  inline const AssociationStateReason& GetStateReason() const { return m_stateReason; }
  inline bool StateReasonHasBeenSet() const { return m_stateReasonHasBeenSet; }
  template <typename StateReasonT = AssociationStateReason>
  void SetStateReason(StateReasonT&& value) {
    m_stateReasonHasBeenSet = true;
    m_stateReason = std::forward<StateReasonT>(value);
  }
  template <typename StateReasonT = AssociationStateReason>
  BundleResourceAssociation& WithStateReason(StateReasonT&& value) {
    SetStateReason(std::forward<StateReasonT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_associatedResourceId;

  BundleAssociatedResourceType m_associatedResourceType{BundleAssociatedResourceType::NOT_SET};

  Aws::String m_bundleId;

  Aws::Utils::DateTime m_created{};

  Aws::Utils::DateTime m_lastUpdatedTime{};

  AssociationState m_state{AssociationState::NOT_SET};

  AssociationStateReason m_stateReason;
  bool m_associatedResourceIdHasBeenSet = false;
  bool m_associatedResourceTypeHasBeenSet = false;
  bool m_bundleIdHasBeenSet = false;
  bool m_createdHasBeenSet = false;
  bool m_lastUpdatedTimeHasBeenSet = false;
  bool m_stateHasBeenSet = false;
  bool m_stateReasonHasBeenSet = false;
};

}  // namespace Model
}  // namespace WorkSpaces
}  // namespace Aws
