﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/voice-id/VoiceID_EXPORTS.h>
#include <aws/voice-id/model/SpeakerEnrollmentJob.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace VoiceID {
namespace Model {
class DescribeSpeakerEnrollmentJobResult {
 public:
  AWS_VOICEID_API DescribeSpeakerEnrollmentJobResult() = default;
  AWS_VOICEID_API DescribeSpeakerEnrollmentJobResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_VOICEID_API DescribeSpeakerEnrollmentJobResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Contains details about the specified speaker enrollment job.</p>
   */
  inline const SpeakerEnrollmentJob& GetJob() const { return m_job; }
  template <typename JobT = SpeakerEnrollmentJob>
  void SetJob(JobT&& value) {
    m_jobHasBeenSet = true;
    m_job = std::forward<JobT>(value);
  }
  template <typename JobT = SpeakerEnrollmentJob>
  DescribeSpeakerEnrollmentJobResult& WithJob(JobT&& value) {
    SetJob(std::forward<JobT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeSpeakerEnrollmentJobResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  SpeakerEnrollmentJob m_job;

  Aws::String m_requestId;
  bool m_jobHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace VoiceID
}  // namespace Aws
