﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/securityhub/SecurityHub_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SecurityHub {
namespace Model {

/**
 * <p> The target account, organizational unit, or the root that is associated with
 * an Security Hub configuration. The configuration can be a configuration policy
 * or self-managed behavior. </p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/Target">AWS
 * API Reference</a></p>
 */
class Target {
 public:
  AWS_SECURITYHUB_API Target() = default;
  AWS_SECURITYHUB_API Target(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API Target& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p> The Amazon Web Services account ID of the target account. </p>
   */
  inline const Aws::String& GetAccountId() const { return m_accountId; }
  inline bool AccountIdHasBeenSet() const { return m_accountIdHasBeenSet; }
  template <typename AccountIdT = Aws::String>
  void SetAccountId(AccountIdT&& value) {
    m_accountIdHasBeenSet = true;
    m_accountId = std::forward<AccountIdT>(value);
  }
  template <typename AccountIdT = Aws::String>
  Target& WithAccountId(AccountIdT&& value) {
    SetAccountId(std::forward<AccountIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The organizational unit ID of the target organizational unit. </p>
   */
  inline const Aws::String& GetOrganizationalUnitId() const { return m_organizationalUnitId; }
  inline bool OrganizationalUnitIdHasBeenSet() const { return m_organizationalUnitIdHasBeenSet; }
  template <typename OrganizationalUnitIdT = Aws::String>
  void SetOrganizationalUnitId(OrganizationalUnitIdT&& value) {
    m_organizationalUnitIdHasBeenSet = true;
    m_organizationalUnitId = std::forward<OrganizationalUnitIdT>(value);
  }
  template <typename OrganizationalUnitIdT = Aws::String>
  Target& WithOrganizationalUnitId(OrganizationalUnitIdT&& value) {
    SetOrganizationalUnitId(std::forward<OrganizationalUnitIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The ID of the organization root. </p>
   */
  inline const Aws::String& GetRootId() const { return m_rootId; }
  inline bool RootIdHasBeenSet() const { return m_rootIdHasBeenSet; }
  template <typename RootIdT = Aws::String>
  void SetRootId(RootIdT&& value) {
    m_rootIdHasBeenSet = true;
    m_rootId = std::forward<RootIdT>(value);
  }
  template <typename RootIdT = Aws::String>
  Target& WithRootId(RootIdT&& value) {
    SetRootId(std::forward<RootIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_accountId;

  Aws::String m_organizationalUnitId;

  Aws::String m_rootId;
  bool m_accountIdHasBeenSet = false;
  bool m_organizationalUnitIdHasBeenSet = false;
  bool m_rootIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SecurityHub
}  // namespace Aws
