﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/securityhub/SecurityHub_EXPORTS.h>
#include <aws/securityhub/model/StandardsControl.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace SecurityHub {
namespace Model {
class DescribeStandardsControlsResult {
 public:
  AWS_SECURITYHUB_API DescribeStandardsControlsResult() = default;
  AWS_SECURITYHUB_API DescribeStandardsControlsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SECURITYHUB_API DescribeStandardsControlsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A list of security standards controls.</p>
   */
  inline const Aws::Vector<StandardsControl>& GetControls() const { return m_controls; }
  template <typename ControlsT = Aws::Vector<StandardsControl>>
  void SetControls(ControlsT&& value) {
    m_controlsHasBeenSet = true;
    m_controls = std::forward<ControlsT>(value);
  }
  template <typename ControlsT = Aws::Vector<StandardsControl>>
  DescribeStandardsControlsResult& WithControls(ControlsT&& value) {
    SetControls(std::forward<ControlsT>(value));
    return *this;
  }
  template <typename ControlsT = StandardsControl>
  DescribeStandardsControlsResult& AddControls(ControlsT&& value) {
    m_controlsHasBeenSet = true;
    m_controls.emplace_back(std::forward<ControlsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The pagination token to use to request the next page of results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  DescribeStandardsControlsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeStandardsControlsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<StandardsControl> m_controls;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_controlsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SecurityHub
}  // namespace Aws
