﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/sagemaker/SageMaker_EXPORTS.h>
#include <aws/sagemaker/model/AutoMLJobCompletionCriteria.h>
#include <aws/sagemaker/model/AutoMLJobObjective.h>
#include <aws/sagemaker/model/ProblemType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SageMaker {
namespace Model {

/**
 * <p>The resolved attributes.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ResolvedAttributes">AWS
 * API Reference</a></p>
 */
class ResolvedAttributes {
 public:
  AWS_SAGEMAKER_API ResolvedAttributes() = default;
  AWS_SAGEMAKER_API ResolvedAttributes(Aws::Utils::Json::JsonView jsonValue);
  AWS_SAGEMAKER_API ResolvedAttributes& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SAGEMAKER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{

  inline const AutoMLJobObjective& GetAutoMLJobObjective() const { return m_autoMLJobObjective; }
  inline bool AutoMLJobObjectiveHasBeenSet() const { return m_autoMLJobObjectiveHasBeenSet; }
  template <typename AutoMLJobObjectiveT = AutoMLJobObjective>
  void SetAutoMLJobObjective(AutoMLJobObjectiveT&& value) {
    m_autoMLJobObjectiveHasBeenSet = true;
    m_autoMLJobObjective = std::forward<AutoMLJobObjectiveT>(value);
  }
  template <typename AutoMLJobObjectiveT = AutoMLJobObjective>
  ResolvedAttributes& WithAutoMLJobObjective(AutoMLJobObjectiveT&& value) {
    SetAutoMLJobObjective(std::forward<AutoMLJobObjectiveT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The problem type.</p>
   */
  inline ProblemType GetProblemType() const { return m_problemType; }
  inline bool ProblemTypeHasBeenSet() const { return m_problemTypeHasBeenSet; }
  inline void SetProblemType(ProblemType value) {
    m_problemTypeHasBeenSet = true;
    m_problemType = value;
  }
  inline ResolvedAttributes& WithProblemType(ProblemType value) {
    SetProblemType(value);
    return *this;
  }
  ///@}

  ///@{

  inline const AutoMLJobCompletionCriteria& GetCompletionCriteria() const { return m_completionCriteria; }
  inline bool CompletionCriteriaHasBeenSet() const { return m_completionCriteriaHasBeenSet; }
  template <typename CompletionCriteriaT = AutoMLJobCompletionCriteria>
  void SetCompletionCriteria(CompletionCriteriaT&& value) {
    m_completionCriteriaHasBeenSet = true;
    m_completionCriteria = std::forward<CompletionCriteriaT>(value);
  }
  template <typename CompletionCriteriaT = AutoMLJobCompletionCriteria>
  ResolvedAttributes& WithCompletionCriteria(CompletionCriteriaT&& value) {
    SetCompletionCriteria(std::forward<CompletionCriteriaT>(value));
    return *this;
  }
  ///@}
 private:
  AutoMLJobObjective m_autoMLJobObjective;

  ProblemType m_problemType{ProblemType::NOT_SET};

  AutoMLJobCompletionCriteria m_completionCriteria;
  bool m_autoMLJobObjectiveHasBeenSet = false;
  bool m_problemTypeHasBeenSet = false;
  bool m_completionCriteriaHasBeenSet = false;
};

}  // namespace Model
}  // namespace SageMaker
}  // namespace Aws
