﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/redshift/Redshift_EXPORTS.h>
#include <aws/redshift/model/ResponseMetadata.h>
#include <aws/redshift/model/Snapshot.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace Redshift {
namespace Model {
class DeleteClusterSnapshotResult {
 public:
  AWS_REDSHIFT_API DeleteClusterSnapshotResult() = default;
  AWS_REDSHIFT_API DeleteClusterSnapshotResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_REDSHIFT_API DeleteClusterSnapshotResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{

  inline const Snapshot& GetSnapshot() const { return m_snapshot; }
  template <typename SnapshotT = Snapshot>
  void SetSnapshot(SnapshotT&& value) {
    m_snapshotHasBeenSet = true;
    m_snapshot = std::forward<SnapshotT>(value);
  }
  template <typename SnapshotT = Snapshot>
  DeleteClusterSnapshotResult& WithSnapshot(SnapshotT&& value) {
    SetSnapshot(std::forward<SnapshotT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  DeleteClusterSnapshotResult& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Snapshot m_snapshot;

  ResponseMetadata m_responseMetadata;
  bool m_snapshotHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace Redshift
}  // namespace Aws
