﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/personalize/Personalize_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Personalize {
namespace Model {
class UpdateSolutionResult {
 public:
  AWS_PERSONALIZE_API UpdateSolutionResult() = default;
  AWS_PERSONALIZE_API UpdateSolutionResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_PERSONALIZE_API UpdateSolutionResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The same solution Amazon Resource Name (ARN) as given in the request.</p>
   */
  inline const Aws::String& GetSolutionArn() const { return m_solutionArn; }
  template <typename SolutionArnT = Aws::String>
  void SetSolutionArn(SolutionArnT&& value) {
    m_solutionArnHasBeenSet = true;
    m_solutionArn = std::forward<SolutionArnT>(value);
  }
  template <typename SolutionArnT = Aws::String>
  UpdateSolutionResult& WithSolutionArn(SolutionArnT&& value) {
    SetSolutionArn(std::forward<SolutionArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  UpdateSolutionResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_solutionArn;

  Aws::String m_requestId;
  bool m_solutionArnHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Personalize
}  // namespace Aws
