﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/odb/OdbRequest.h>
#include <aws/odb/Odb_EXPORTS.h>

namespace Aws {
namespace odb {
namespace Model {

/**
 */
class InitializeServiceRequest : public OdbRequest {
 public:
  AWS_ODB_API InitializeServiceRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "InitializeService"; }

  AWS_ODB_API Aws::String SerializePayload() const override;

  AWS_ODB_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The Oracle Cloud Infrastructure (OCI) identity domain configuration for
   * service initialization.</p>
   */
  inline bool GetOciIdentityDomain() const { return m_ociIdentityDomain; }
  inline bool OciIdentityDomainHasBeenSet() const { return m_ociIdentityDomainHasBeenSet; }
  inline void SetOciIdentityDomain(bool value) {
    m_ociIdentityDomainHasBeenSet = true;
    m_ociIdentityDomain = value;
  }
  inline InitializeServiceRequest& WithOciIdentityDomain(bool value) {
    SetOciIdentityDomain(value);
    return *this;
  }
  ///@}
 private:
  bool m_ociIdentityDomain{false};
  bool m_ociIdentityDomainHasBeenSet = false;
};

}  // namespace Model
}  // namespace odb
}  // namespace Aws
