﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/monitoring/CloudWatch_EXPORTS.h>

namespace Aws {
namespace CloudWatch {
namespace Model {
enum class ComparisonOperator {
  NOT_SET,
  GreaterThanOrEqualToThreshold,
  GreaterThanThreshold,
  LessThanThreshold,
  LessThanOrEqualToThreshold,
  LessThanLowerOrGreaterThanUpperThreshold,
  LessThanLowerThreshold,
  GreaterThanUpperThreshold
};

namespace ComparisonOperatorMapper {
AWS_CLOUDWATCH_API ComparisonOperator GetComparisonOperatorForName(const Aws::String& name);

AWS_CLOUDWATCH_API Aws::String GetNameForComparisonOperator(ComparisonOperator value);
}  // namespace ComparisonOperatorMapper
}  // namespace Model
}  // namespace CloudWatch
}  // namespace Aws
