﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/memorydb/MemoryDBRequest.h>
#include <aws/memorydb/MemoryDB_EXPORTS.h>

#include <utility>

namespace Aws {
namespace MemoryDB {
namespace Model {

/**
 */
class DeleteMultiRegionClusterRequest : public MemoryDBRequest {
 public:
  AWS_MEMORYDB_API DeleteMultiRegionClusterRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteMultiRegionCluster"; }

  AWS_MEMORYDB_API Aws::String SerializePayload() const override;

  AWS_MEMORYDB_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The name of the multi-Region cluster to be deleted.</p>
   */
  inline const Aws::String& GetMultiRegionClusterName() const { return m_multiRegionClusterName; }
  inline bool MultiRegionClusterNameHasBeenSet() const { return m_multiRegionClusterNameHasBeenSet; }
  template <typename MultiRegionClusterNameT = Aws::String>
  void SetMultiRegionClusterName(MultiRegionClusterNameT&& value) {
    m_multiRegionClusterNameHasBeenSet = true;
    m_multiRegionClusterName = std::forward<MultiRegionClusterNameT>(value);
  }
  template <typename MultiRegionClusterNameT = Aws::String>
  DeleteMultiRegionClusterRequest& WithMultiRegionClusterName(MultiRegionClusterNameT&& value) {
    SetMultiRegionClusterName(std::forward<MultiRegionClusterNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_multiRegionClusterName;
  bool m_multiRegionClusterNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace MemoryDB
}  // namespace Aws
