﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/lookoutequipment/LookoutEquipmentRequest.h>
#include <aws/lookoutequipment/LookoutEquipment_EXPORTS.h>

#include <utility>

namespace Aws {
namespace LookoutEquipment {
namespace Model {

/**
 */
class DeleteLabelGroupRequest : public LookoutEquipmentRequest {
 public:
  AWS_LOOKOUTEQUIPMENT_API DeleteLabelGroupRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteLabelGroup"; }

  AWS_LOOKOUTEQUIPMENT_API Aws::String SerializePayload() const override;

  AWS_LOOKOUTEQUIPMENT_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p> The name of the label group that you want to delete. Data in this field will
   * be retained for service usage. Follow best practices for the security of your
   * data. </p>
   */
  inline const Aws::String& GetLabelGroupName() const { return m_labelGroupName; }
  inline bool LabelGroupNameHasBeenSet() const { return m_labelGroupNameHasBeenSet; }
  template <typename LabelGroupNameT = Aws::String>
  void SetLabelGroupName(LabelGroupNameT&& value) {
    m_labelGroupNameHasBeenSet = true;
    m_labelGroupName = std::forward<LabelGroupNameT>(value);
  }
  template <typename LabelGroupNameT = Aws::String>
  DeleteLabelGroupRequest& WithLabelGroupName(LabelGroupNameT&& value) {
    SetLabelGroupName(std::forward<LabelGroupNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_labelGroupName;
  bool m_labelGroupNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace LookoutEquipment
}  // namespace Aws
