﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/lightsail/Lightsail_EXPORTS.h>
#include <aws/lightsail/model/AddOn.h>
#include <aws/lightsail/model/InstanceHardware.h>
#include <aws/lightsail/model/InstanceMetadataOptions.h>
#include <aws/lightsail/model/InstanceNetworking.h>
#include <aws/lightsail/model/InstanceState.h>
#include <aws/lightsail/model/IpAddressType.h>
#include <aws/lightsail/model/ResourceLocation.h>
#include <aws/lightsail/model/ResourceType.h>
#include <aws/lightsail/model/Tag.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Lightsail {
namespace Model {

/**
 * <p>Describes an instance (a virtual private server).</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/Instance">AWS
 * API Reference</a></p>
 */
class Instance {
 public:
  AWS_LIGHTSAIL_API Instance() = default;
  AWS_LIGHTSAIL_API Instance(Aws::Utils::Json::JsonView jsonValue);
  AWS_LIGHTSAIL_API Instance& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_LIGHTSAIL_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name the user gave the instance (<code>Amazon_Linux_2023-1</code>).</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  Instance& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the instance
   * (<code>arn:aws:lightsail:us-east-2:123456789101:Instance/244ad76f-8aad-4741-809f-12345EXAMPLE</code>).</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  Instance& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The support code. Include this code in your email to support when you have
   * questions about an instance or another resource in Lightsail. This code enables
   * our support team to look up your Lightsail information more easily.</p>
   */
  inline const Aws::String& GetSupportCode() const { return m_supportCode; }
  inline bool SupportCodeHasBeenSet() const { return m_supportCodeHasBeenSet; }
  template <typename SupportCodeT = Aws::String>
  void SetSupportCode(SupportCodeT&& value) {
    m_supportCodeHasBeenSet = true;
    m_supportCode = std::forward<SupportCodeT>(value);
  }
  template <typename SupportCodeT = Aws::String>
  Instance& WithSupportCode(SupportCodeT&& value) {
    SetSupportCode(std::forward<SupportCodeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The timestamp when the instance was created (<code>1479734909.17</code>) in
   * Unix time format.</p>
   */
  inline const Aws::Utils::DateTime& GetCreatedAt() const { return m_createdAt; }
  inline bool CreatedAtHasBeenSet() const { return m_createdAtHasBeenSet; }
  template <typename CreatedAtT = Aws::Utils::DateTime>
  void SetCreatedAt(CreatedAtT&& value) {
    m_createdAtHasBeenSet = true;
    m_createdAt = std::forward<CreatedAtT>(value);
  }
  template <typename CreatedAtT = Aws::Utils::DateTime>
  Instance& WithCreatedAt(CreatedAtT&& value) {
    SetCreatedAt(std::forward<CreatedAtT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The region name and Availability Zone where the instance is located.</p>
   */
  inline const ResourceLocation& GetLocation() const { return m_location; }
  inline bool LocationHasBeenSet() const { return m_locationHasBeenSet; }
  template <typename LocationT = ResourceLocation>
  void SetLocation(LocationT&& value) {
    m_locationHasBeenSet = true;
    m_location = std::forward<LocationT>(value);
  }
  template <typename LocationT = ResourceLocation>
  Instance& WithLocation(LocationT&& value) {
    SetLocation(std::forward<LocationT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of resource (usually <code>Instance</code>).</p>
   */
  inline ResourceType GetResourceType() const { return m_resourceType; }
  inline bool ResourceTypeHasBeenSet() const { return m_resourceTypeHasBeenSet; }
  inline void SetResourceType(ResourceType value) {
    m_resourceTypeHasBeenSet = true;
    m_resourceType = value;
  }
  inline Instance& WithResourceType(ResourceType value) {
    SetResourceType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The tag keys and optional values for the resource. For more information about
   * tags in Lightsail, see the <a
   * href="https://docs.aws.amazon.com/lightsail/latest/userguide/amazon-lightsail-tags">Amazon
   * Lightsail Developer Guide</a>.</p>
   */
  inline const Aws::Vector<Tag>& GetTags() const { return m_tags; }
  inline bool TagsHasBeenSet() const { return m_tagsHasBeenSet; }
  template <typename TagsT = Aws::Vector<Tag>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Vector<Tag>>
  Instance& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsT = Tag>
  Instance& AddTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace_back(std::forward<TagsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The blueprint ID (<code>amazon_linux_2023</code>).</p>
   */
  inline const Aws::String& GetBlueprintId() const { return m_blueprintId; }
  inline bool BlueprintIdHasBeenSet() const { return m_blueprintIdHasBeenSet; }
  template <typename BlueprintIdT = Aws::String>
  void SetBlueprintId(BlueprintIdT&& value) {
    m_blueprintIdHasBeenSet = true;
    m_blueprintId = std::forward<BlueprintIdT>(value);
  }
  template <typename BlueprintIdT = Aws::String>
  Instance& WithBlueprintId(BlueprintIdT&& value) {
    SetBlueprintId(std::forward<BlueprintIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The friendly name of the blueprint (<code>Amazon Linux 2023</code>).</p>
   */
  inline const Aws::String& GetBlueprintName() const { return m_blueprintName; }
  inline bool BlueprintNameHasBeenSet() const { return m_blueprintNameHasBeenSet; }
  template <typename BlueprintNameT = Aws::String>
  void SetBlueprintName(BlueprintNameT&& value) {
    m_blueprintNameHasBeenSet = true;
    m_blueprintName = std::forward<BlueprintNameT>(value);
  }
  template <typename BlueprintNameT = Aws::String>
  Instance& WithBlueprintName(BlueprintNameT&& value) {
    SetBlueprintName(std::forward<BlueprintNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The bundle for the instance (<code>micro_x_x</code>).</p>
   */
  inline const Aws::String& GetBundleId() const { return m_bundleId; }
  inline bool BundleIdHasBeenSet() const { return m_bundleIdHasBeenSet; }
  template <typename BundleIdT = Aws::String>
  void SetBundleId(BundleIdT&& value) {
    m_bundleIdHasBeenSet = true;
    m_bundleId = std::forward<BundleIdT>(value);
  }
  template <typename BundleIdT = Aws::String>
  Instance& WithBundleId(BundleIdT&& value) {
    SetBundleId(std::forward<BundleIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An array of objects representing the add-ons enabled on the instance.</p>
   */
  inline const Aws::Vector<AddOn>& GetAddOns() const { return m_addOns; }
  inline bool AddOnsHasBeenSet() const { return m_addOnsHasBeenSet; }
  template <typename AddOnsT = Aws::Vector<AddOn>>
  void SetAddOns(AddOnsT&& value) {
    m_addOnsHasBeenSet = true;
    m_addOns = std::forward<AddOnsT>(value);
  }
  template <typename AddOnsT = Aws::Vector<AddOn>>
  Instance& WithAddOns(AddOnsT&& value) {
    SetAddOns(std::forward<AddOnsT>(value));
    return *this;
  }
  template <typename AddOnsT = AddOn>
  Instance& AddAddOns(AddOnsT&& value) {
    m_addOnsHasBeenSet = true;
    m_addOns.emplace_back(std::forward<AddOnsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A Boolean value indicating whether this instance has a static IP assigned to
   * it.</p>
   */
  inline bool GetIsStaticIp() const { return m_isStaticIp; }
  inline bool IsStaticIpHasBeenSet() const { return m_isStaticIpHasBeenSet; }
  inline void SetIsStaticIp(bool value) {
    m_isStaticIpHasBeenSet = true;
    m_isStaticIp = value;
  }
  inline Instance& WithIsStaticIp(bool value) {
    SetIsStaticIp(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The private IP address of the instance.</p>
   */
  inline const Aws::String& GetPrivateIpAddress() const { return m_privateIpAddress; }
  inline bool PrivateIpAddressHasBeenSet() const { return m_privateIpAddressHasBeenSet; }
  template <typename PrivateIpAddressT = Aws::String>
  void SetPrivateIpAddress(PrivateIpAddressT&& value) {
    m_privateIpAddressHasBeenSet = true;
    m_privateIpAddress = std::forward<PrivateIpAddressT>(value);
  }
  template <typename PrivateIpAddressT = Aws::String>
  Instance& WithPrivateIpAddress(PrivateIpAddressT&& value) {
    SetPrivateIpAddress(std::forward<PrivateIpAddressT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The public IP address of the instance.</p>
   */
  inline const Aws::String& GetPublicIpAddress() const { return m_publicIpAddress; }
  inline bool PublicIpAddressHasBeenSet() const { return m_publicIpAddressHasBeenSet; }
  template <typename PublicIpAddressT = Aws::String>
  void SetPublicIpAddress(PublicIpAddressT&& value) {
    m_publicIpAddressHasBeenSet = true;
    m_publicIpAddress = std::forward<PublicIpAddressT>(value);
  }
  template <typename PublicIpAddressT = Aws::String>
  Instance& WithPublicIpAddress(PublicIpAddressT&& value) {
    SetPublicIpAddress(std::forward<PublicIpAddressT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The IPv6 addresses of the instance.</p>
   */
  inline const Aws::Vector<Aws::String>& GetIpv6Addresses() const { return m_ipv6Addresses; }
  inline bool Ipv6AddressesHasBeenSet() const { return m_ipv6AddressesHasBeenSet; }
  template <typename Ipv6AddressesT = Aws::Vector<Aws::String>>
  void SetIpv6Addresses(Ipv6AddressesT&& value) {
    m_ipv6AddressesHasBeenSet = true;
    m_ipv6Addresses = std::forward<Ipv6AddressesT>(value);
  }
  template <typename Ipv6AddressesT = Aws::Vector<Aws::String>>
  Instance& WithIpv6Addresses(Ipv6AddressesT&& value) {
    SetIpv6Addresses(std::forward<Ipv6AddressesT>(value));
    return *this;
  }
  template <typename Ipv6AddressesT = Aws::String>
  Instance& AddIpv6Addresses(Ipv6AddressesT&& value) {
    m_ipv6AddressesHasBeenSet = true;
    m_ipv6Addresses.emplace_back(std::forward<Ipv6AddressesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The IP address type of the instance.</p> <p>The possible values are
   * <code>ipv4</code> for IPv4 only, <code>ipv6</code> for IPv6 only, and
   * <code>dualstack</code> for IPv4 and IPv6.</p>
   */
  inline IpAddressType GetIpAddressType() const { return m_ipAddressType; }
  inline bool IpAddressTypeHasBeenSet() const { return m_ipAddressTypeHasBeenSet; }
  inline void SetIpAddressType(IpAddressType value) {
    m_ipAddressTypeHasBeenSet = true;
    m_ipAddressType = value;
  }
  inline Instance& WithIpAddressType(IpAddressType value) {
    SetIpAddressType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The size of the vCPU and the amount of RAM for the instance.</p>
   */
  inline const InstanceHardware& GetHardware() const { return m_hardware; }
  inline bool HardwareHasBeenSet() const { return m_hardwareHasBeenSet; }
  template <typename HardwareT = InstanceHardware>
  void SetHardware(HardwareT&& value) {
    m_hardwareHasBeenSet = true;
    m_hardware = std::forward<HardwareT>(value);
  }
  template <typename HardwareT = InstanceHardware>
  Instance& WithHardware(HardwareT&& value) {
    SetHardware(std::forward<HardwareT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Information about the public ports and monthly data transfer rates for the
   * instance.</p>
   */
  inline const InstanceNetworking& GetNetworking() const { return m_networking; }
  inline bool NetworkingHasBeenSet() const { return m_networkingHasBeenSet; }
  template <typename NetworkingT = InstanceNetworking>
  void SetNetworking(NetworkingT&& value) {
    m_networkingHasBeenSet = true;
    m_networking = std::forward<NetworkingT>(value);
  }
  template <typename NetworkingT = InstanceNetworking>
  Instance& WithNetworking(NetworkingT&& value) {
    SetNetworking(std::forward<NetworkingT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status code and the state (<code>running</code>) for the instance.</p>
   */
  inline const InstanceState& GetState() const { return m_state; }
  inline bool StateHasBeenSet() const { return m_stateHasBeenSet; }
  template <typename StateT = InstanceState>
  void SetState(StateT&& value) {
    m_stateHasBeenSet = true;
    m_state = std::forward<StateT>(value);
  }
  template <typename StateT = InstanceState>
  Instance& WithState(StateT&& value) {
    SetState(std::forward<StateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The user name for connecting to the instance (<code>ec2-user</code>).</p>
   */
  inline const Aws::String& GetUsername() const { return m_username; }
  inline bool UsernameHasBeenSet() const { return m_usernameHasBeenSet; }
  template <typename UsernameT = Aws::String>
  void SetUsername(UsernameT&& value) {
    m_usernameHasBeenSet = true;
    m_username = std::forward<UsernameT>(value);
  }
  template <typename UsernameT = Aws::String>
  Instance& WithUsername(UsernameT&& value) {
    SetUsername(std::forward<UsernameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the SSH key being used to connect to the instance
   * (<code>LightsailDefaultKeyPair</code>).</p>
   */
  inline const Aws::String& GetSshKeyName() const { return m_sshKeyName; }
  inline bool SshKeyNameHasBeenSet() const { return m_sshKeyNameHasBeenSet; }
  template <typename SshKeyNameT = Aws::String>
  void SetSshKeyName(SshKeyNameT&& value) {
    m_sshKeyNameHasBeenSet = true;
    m_sshKeyName = std::forward<SshKeyNameT>(value);
  }
  template <typename SshKeyNameT = Aws::String>
  Instance& WithSshKeyName(SshKeyNameT&& value) {
    SetSshKeyName(std::forward<SshKeyNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The metadata options for the Amazon Lightsail instance.</p>
   */
  inline const InstanceMetadataOptions& GetMetadataOptions() const { return m_metadataOptions; }
  inline bool MetadataOptionsHasBeenSet() const { return m_metadataOptionsHasBeenSet; }
  template <typename MetadataOptionsT = InstanceMetadataOptions>
  void SetMetadataOptions(MetadataOptionsT&& value) {
    m_metadataOptionsHasBeenSet = true;
    m_metadataOptions = std::forward<MetadataOptionsT>(value);
  }
  template <typename MetadataOptionsT = InstanceMetadataOptions>
  Instance& WithMetadataOptions(MetadataOptionsT&& value) {
    SetMetadataOptions(std::forward<MetadataOptionsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;

  Aws::String m_arn;

  Aws::String m_supportCode;

  Aws::Utils::DateTime m_createdAt{};

  ResourceLocation m_location;

  ResourceType m_resourceType{ResourceType::NOT_SET};

  Aws::Vector<Tag> m_tags;

  Aws::String m_blueprintId;

  Aws::String m_blueprintName;

  Aws::String m_bundleId;

  Aws::Vector<AddOn> m_addOns;

  bool m_isStaticIp{false};

  Aws::String m_privateIpAddress;

  Aws::String m_publicIpAddress;

  Aws::Vector<Aws::String> m_ipv6Addresses;

  IpAddressType m_ipAddressType{IpAddressType::NOT_SET};

  InstanceHardware m_hardware;

  InstanceNetworking m_networking;

  InstanceState m_state;

  Aws::String m_username;

  Aws::String m_sshKeyName;

  InstanceMetadataOptions m_metadataOptions;
  bool m_nameHasBeenSet = false;
  bool m_arnHasBeenSet = false;
  bool m_supportCodeHasBeenSet = false;
  bool m_createdAtHasBeenSet = false;
  bool m_locationHasBeenSet = false;
  bool m_resourceTypeHasBeenSet = false;
  bool m_tagsHasBeenSet = false;
  bool m_blueprintIdHasBeenSet = false;
  bool m_blueprintNameHasBeenSet = false;
  bool m_bundleIdHasBeenSet = false;
  bool m_addOnsHasBeenSet = false;
  bool m_isStaticIpHasBeenSet = false;
  bool m_privateIpAddressHasBeenSet = false;
  bool m_publicIpAddressHasBeenSet = false;
  bool m_ipv6AddressesHasBeenSet = false;
  bool m_ipAddressTypeHasBeenSet = false;
  bool m_hardwareHasBeenSet = false;
  bool m_networkingHasBeenSet = false;
  bool m_stateHasBeenSet = false;
  bool m_usernameHasBeenSet = false;
  bool m_sshKeyNameHasBeenSet = false;
  bool m_metadataOptionsHasBeenSet = false;
};

}  // namespace Model
}  // namespace Lightsail
}  // namespace Aws
