﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iottwinmaker/IoTTwinMaker_EXPORTS.h>
#include <aws/iottwinmaker/model/MetadataTransferJobProgress.h>
#include <aws/iottwinmaker/model/MetadataTransferJobStatus.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace IoTTwinMaker {
namespace Model {

/**
 * <p>The metadata transfer job summary.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/MetadataTransferJobSummary">AWS
 * API Reference</a></p>
 */
class MetadataTransferJobSummary {
 public:
  AWS_IOTTWINMAKER_API MetadataTransferJobSummary() = default;
  AWS_IOTTWINMAKER_API MetadataTransferJobSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTTWINMAKER_API MetadataTransferJobSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTTWINMAKER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The metadata transfer job summary Id.</p>
   */
  inline const Aws::String& GetMetadataTransferJobId() const { return m_metadataTransferJobId; }
  inline bool MetadataTransferJobIdHasBeenSet() const { return m_metadataTransferJobIdHasBeenSet; }
  template <typename MetadataTransferJobIdT = Aws::String>
  void SetMetadataTransferJobId(MetadataTransferJobIdT&& value) {
    m_metadataTransferJobIdHasBeenSet = true;
    m_metadataTransferJobId = std::forward<MetadataTransferJobIdT>(value);
  }
  template <typename MetadataTransferJobIdT = Aws::String>
  MetadataTransferJobSummary& WithMetadataTransferJobId(MetadataTransferJobIdT&& value) {
    SetMetadataTransferJobId(std::forward<MetadataTransferJobIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The metadata transfer job summary ARN.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  MetadataTransferJobSummary& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The metadata transfer job summary creation DateTime object.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationDateTime() const { return m_creationDateTime; }
  inline bool CreationDateTimeHasBeenSet() const { return m_creationDateTimeHasBeenSet; }
  template <typename CreationDateTimeT = Aws::Utils::DateTime>
  void SetCreationDateTime(CreationDateTimeT&& value) {
    m_creationDateTimeHasBeenSet = true;
    m_creationDateTime = std::forward<CreationDateTimeT>(value);
  }
  template <typename CreationDateTimeT = Aws::Utils::DateTime>
  MetadataTransferJobSummary& WithCreationDateTime(CreationDateTimeT&& value) {
    SetCreationDateTime(std::forward<CreationDateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The metadata transfer job summary update DateTime object</p>
   */
  inline const Aws::Utils::DateTime& GetUpdateDateTime() const { return m_updateDateTime; }
  inline bool UpdateDateTimeHasBeenSet() const { return m_updateDateTimeHasBeenSet; }
  template <typename UpdateDateTimeT = Aws::Utils::DateTime>
  void SetUpdateDateTime(UpdateDateTimeT&& value) {
    m_updateDateTimeHasBeenSet = true;
    m_updateDateTime = std::forward<UpdateDateTimeT>(value);
  }
  template <typename UpdateDateTimeT = Aws::Utils::DateTime>
  MetadataTransferJobSummary& WithUpdateDateTime(UpdateDateTimeT&& value) {
    SetUpdateDateTime(std::forward<UpdateDateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The metadata transfer job summary status.</p>
   */
  inline const MetadataTransferJobStatus& GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  template <typename StatusT = MetadataTransferJobStatus>
  void SetStatus(StatusT&& value) {
    m_statusHasBeenSet = true;
    m_status = std::forward<StatusT>(value);
  }
  template <typename StatusT = MetadataTransferJobStatus>
  MetadataTransferJobSummary& WithStatus(StatusT&& value) {
    SetStatus(std::forward<StatusT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The metadata transfer job summary progess.</p>
   */
  inline const MetadataTransferJobProgress& GetProgress() const { return m_progress; }
  inline bool ProgressHasBeenSet() const { return m_progressHasBeenSet; }
  template <typename ProgressT = MetadataTransferJobProgress>
  void SetProgress(ProgressT&& value) {
    m_progressHasBeenSet = true;
    m_progress = std::forward<ProgressT>(value);
  }
  template <typename ProgressT = MetadataTransferJobProgress>
  MetadataTransferJobSummary& WithProgress(ProgressT&& value) {
    SetProgress(std::forward<ProgressT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_metadataTransferJobId;

  Aws::String m_arn;

  Aws::Utils::DateTime m_creationDateTime{};

  Aws::Utils::DateTime m_updateDateTime{};

  MetadataTransferJobStatus m_status;

  MetadataTransferJobProgress m_progress;
  bool m_metadataTransferJobIdHasBeenSet = false;
  bool m_arnHasBeenSet = false;
  bool m_creationDateTimeHasBeenSet = false;
  bool m_updateDateTimeHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_progressHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTTwinMaker
}  // namespace Aws
